package com.atlassian.user.impl;

import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.security.password.Credential;

public abstract class ReadOnlyUserManager implements UserManager
{
    public User createUser(String username) throws EntityException
    {
        throw newUnsupportedOperationException();
    }

    public User createUser(User userTemplate, Credential credential) throws EntityException
    {
        throw newUnsupportedOperationException();
    }

    public void alterPassword(User user, String plainTextPass) throws EntityException
    {
        throw newUnsupportedOperationException();
    }

    @Override
    public User renameUser(final User user, final String userName)
    {
        throw newUnsupportedOperationException();
    }

    @Override
    public User onExternalUserRename(final String oldName, final String newName)
    {
        throw newUnsupportedOperationException();
    }

    public User saveUser(User user) throws EntityException
    {
        throw newUnsupportedOperationException();
    }

    public void removeUser(User user) throws EntityException
    {
        throw newUnsupportedOperationException();
    }

    public boolean isReadOnly(User user) throws EntityException
    {
        return (getUser(user.getName()) != null);
    }

    public boolean isCreative()
    {
        return false;
    }

    private UnsupportedOperationException newUnsupportedOperationException()
    {
        return new UnsupportedOperationException("Cannot write to read-only UserManager [" + getIdentifier().getKey() + "]");
    }
}
