package com.atlassian.user.impl.as.security.authentication;

import com.atlassian.security.password.DefaultPasswordEncoder;
import com.atlassian.security.password.PasswordEncoder;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.user.security.authentication.EntityAuthenticationException;
import com.atlassian.user.security.password.DefaultPasswordEncryptor;
import com.atlassian.user.security.password.PasswordEncryptor;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ASAuthenticator implements Authenticator
{
    @SuppressWarnings("UnusedDeclaration")
    private static final Logger log = Logger.getLogger(ASAuthenticator.class);
    // ------------------------------------------------------------------------------------------------------- Constants
    private static final PasswordEncoder PASSWORD_ENCODER = DefaultPasswordEncoder.getDefaultInstance();
    // ------------------------------------------------------------------------------------------------- Type Properties
    private final UserManager userManager;
    private final PasswordEncryptor legacyEncryptor;
    // ---------------------------------------------------------------------------------------------------- Dependencies
    // ---------------------------------------------------------------------------------------------------- Constructors

    public ASAuthenticator(UserManager userManager)
    {
        this.userManager = userManager;
        this.legacyEncryptor = new DefaultPasswordEncryptor();
    }

    // ----------------------------------------------------------------------------------------------- Interface Methods

    @Override
    public boolean authenticate(String username, String password) throws EntityException
    {
        User user = userManager.getUser(username);

        if (user instanceof DefaultUser)
        {
            DefaultUser defaultUser = (DefaultUser) user;
            try
            {
                final String encodedPassword = defaultUser.getPassword();
                if (encodedPassword != null)
                {
                    if (PASSWORD_ENCODER.canDecodePassword(encodedPassword))
                    {
                        return PASSWORD_ENCODER.isValidPassword(password, encodedPassword);
                    }
                    else {
                        // fall back to old password mechanism
                        boolean isValid = encodedPassword.equals(legacyEncryptor.encrypt(password));
                        if (isValid && !StringUtils.isEmpty(password))
                        {
                            // user provided a correct password, so let's upgrade the encoded value to the new format
                            userManager.alterPassword(defaultUser, password);
                        }
                        return isValid;
                    }
                }
            }
            catch (Exception e)
            {
                throw new EntityAuthenticationException(e);
            }
        }

        return false;
    }

    @Override
    public RepositoryIdentifier getRepository()
    {
        return userManager.getIdentifier();
    }

    // -------------------------------------------------------------------------------------------------- Action Methods
    // -------------------------------------------------------------------------------------------------- Public Methods
    // -------------------------------------------------------------------------------------- Basic Accessors / Mutators
}
