package com.atlassian.user.impl.as.security.password;

import com.atlassian.security.password.DefaultPasswordEncoder;
import com.atlassian.security.password.PasswordEncoder;
import com.atlassian.user.security.password.Credential;
import com.atlassian.user.security.password.PasswordEncryptor;
import org.apache.log4j.Logger;

public class ASPasswordEncryptor implements PasswordEncryptor
{
    private static final PasswordEncoder PASSWORD_ENCODER = DefaultPasswordEncoder.getDefaultInstance();

    @Override
    public String encrypt(String unencryptedPassword)
    {
        return PASSWORD_ENCODER.encodePassword(unencryptedPassword);
    }

    @Override
    public String getEncryptedValue(final Credential credential)
    {
        if (credential.isEncrypted())
        {
            return credential.getValue();
        }
        else
        {
            return encrypt(credential.getValue());
        }
    }
}
