package com.atlassian.user.impl.delegation.repository;

import com.atlassian.user.repository.RepositoryIdentifier;

import java.util.*;

public class DelegatingRepository implements RepositoryIdentifier
{
    public static final String DELEGATING = "Delegating Repository: ";
    private final List<RepositoryIdentifier> repositories = new ArrayList<RepositoryIdentifier>();

    public DelegatingRepository(final List<RepositoryIdentifier> repositories)
    {
        this.repositories.addAll(repositories);
    }

    public String getKey()
    {
        StringBuffer key = new StringBuffer(DELEGATING.length() + (30 * repositories.size()));
        key.append(DELEGATING);

        for (RepositoryIdentifier repository : repositories)
        {
            key.append(repository.getKey()).append(" ");
        }

        return key.toString();
    }

    public String getName()
    {
        StringBuffer name = new StringBuffer(DELEGATING.length() + (50 * repositories.size()));
        name.append(DELEGATING);

        for (RepositoryIdentifier repository : repositories)
        {
            name.append(repository.getName()).append(" ");
        }

        return name.toString();
    }

    public String getDescription()
    {
        return DELEGATING;
    }

    public List<RepositoryIdentifier> getRepositories()
    {
        return repositories;    
    }
}
