package com.atlassian.user.search.query;

import com.atlassian.user.Entity;

import java.util.List;
import java.util.ArrayList;

public abstract class AbstractBooleanQuery<T extends Entity> implements BooleanQuery<T>
{
    protected boolean anding;
    protected List<Query<T>> queries = new ArrayList<Query<T>>();

    protected AbstractBooleanQuery(boolean anding)
    {
        this.anding = anding;
    }

    protected AbstractBooleanQuery(String anding)
    {
        if (anding.equals(AND))
            this.anding = true;
    }

    /**
     * It is impossible for isAND() and isOR() to both return true or false.
     *
     * @return true if the clause is set to AND the two queries.
     */
    public boolean isAND()
    {
        return anding;
    }

    /**
     * @return true if the clause is set to OR the two queries
     */
    public boolean isOR()
    {
        return !anding;
    }

    public List<Query<T>> getQueries()
    {
        return queries;
    }
}
