package com.atlassian.user.search.query;

import com.atlassian.user.Entity;

public class TwoTermBooleanQuery<T extends Entity> extends AbstractBooleanQuery<T>
{
    private Query<T> query1;
    private Query<T> query2;

    /**
     * Defaults anding to true
     */ 
    public TwoTermBooleanQuery(Query<T> query1, Query<T> query2)
    {
        super(true);
        this.query1 = query1;
        this.query2 = query2;

        queries.add(query1);
        queries.add(query2);
    }

    public TwoTermBooleanQuery(Query<T> query1, Query<T> query2, String anding)
    {
        super(anding);
        this.query1 = query1;
        this.query2 = query2;

        queries.add(query1);
        queries.add(query2);
    }


    public TwoTermBooleanQuery(Query<T> query1, Query<T> query2, boolean anding)
    {
        super(anding);
        this.query1 = query1;
        this.query2 = query2;
        this.anding = anding;

        queries.add(query1);
        queries.add(query2);
    }

    public Query<T> getFirstQuery()
    {
        return query1;
    }

    public Query<T> getSecondQuery()
    {
        return query2;
    }
}
