package com.atlassian.user.util;

import java.util.Enumeration;
import java.util.Iterator;

/**
 * Wraps an enumeration with an iterator interface
 */
public class EnumerationAdaptor<T> implements Iterator<T>
{
    private final Enumeration<T> enumeration;

    public EnumerationAdaptor(Enumeration<T> enumeration)
    {
        Assert.notNull(enumeration, "enumeration");
        this.enumeration = enumeration;
    }

    public void remove()
    {
        throw new UnsupportedOperationException();
    }

    public boolean hasNext()
    {
        return enumeration.hasMoreElements();
    }

    public T next()
    {
        return enumeration.nextElement();
    }
}
