/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.delegation.security.authentication;

import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.delegation.repository.DelegatingRepository;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.security.authentication.Authenticator;
import com.atlassian.user.util.UtilTimerStackUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;

public class DelegatingAuthenticator
implements Authenticator {
    private static final Logger log = Logger.getLogger(DelegatingAuthenticator.class);
    private final List<Authenticator> authenticators;
    private final UserManager userManager;

    public DelegatingAuthenticator(UserManager userManager, List<Authenticator> authenticators) {
        this.userManager = userManager;
        this.authenticators = authenticators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean authenticate(String username, String password) throws EntityException {
        Supplier<String> profilerMessageSupplier = () -> this.getClass().getName() + "_delegating_authenticate(" + username + ")";
        UtilTimerStackUtils.push(profilerMessageSupplier);
        try {
            User user = this.userManager.getUser(username);
            Objects.requireNonNull(user, "User " + username + " not found in " + this.userManager.getIdentifier());
            RepositoryIdentifier repository = this.userManager.getRepository((Entity)user);
            List<Authenticator> authenticators = this.getAuthenticatorsForRepository(repository);
            if (authenticators.isEmpty()) {
                log.error((Object)("Failed to find authenticator for user " + username + " from repository " + repository));
                boolean bl = false;
                return bl;
            }
            for (Authenticator authenticator : authenticators) {
                if (!this.authenticate(authenticator, username, password)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            UtilTimerStackUtils.pop(profilerMessageSupplier);
        }
        return false;
    }

    private boolean authenticate(Authenticator authenticator, String username, String password) {
        try {
            return authenticator.authenticate(username, password);
        }
        catch (EntityException e) {
            log.error((Object)(authenticator.getRepository() + ": " + e.getMessage()));
            return false;
        }
    }

    private List<Authenticator> getAuthenticatorsForRepository(RepositoryIdentifier repository) {
        return this.authenticators.stream().filter(authenticator -> authenticator.getRepository().equals(repository)).collect(Collectors.toCollection(LinkedList::new));
    }

    public RepositoryIdentifier getRepository() {
        return new DelegatingRepository(this.authenticators.stream().map(Authenticator::getRepository).collect(Collectors.toList()));
    }

    public List<Authenticator> getAuthenticators() {
        return this.authenticators;
    }
}

