/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.user.impl.cache;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.impl.DefaultUser;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.password.Credential;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachingUserManager
implements UserManager {
    private static final Logger log = Logger.getLogger(CachingUserManager.class);
    private final UserManager underlyingUserManager;
    private final CacheFactory cacheFactory;
    private String userCacheName = null;
    private String userROCacheName = null;
    private String repositoryCacheName = null;
    private static final String CACHE_SUFFIX_USERS = "users";
    private static final String CACHE_SUFFIX_USERS_RO = "users_ro";
    private static final String CACHE_SUFFIX_REPOSITORIES = "repository";
    protected static User NULL_USER = new DefaultUser(){

        @Override
        public String toString() {
            return "NULL USER";
        }
    };

    public CachingUserManager(UserManager underlyingUserManager, CacheFactory cacheFactory) {
        this.underlyingUserManager = underlyingUserManager;
        this.cacheFactory = cacheFactory;
    }

    public Pager<User> getUsers() throws EntityException {
        return this.underlyingUserManager.getUsers();
    }

    public Pager<String> getUserNames() throws EntityException {
        return this.underlyingUserManager.getUserNames();
    }

    @Nullable
    public User getUser(@NotNull String username) throws EntityException {
        User cachedUser = (User)this.getUserCache().get((Object)username);
        if (cachedUser != null) {
            return NULL_USER.equals(cachedUser) ? null : cachedUser;
        }
        User user = this.underlyingUserManager.getUser(username);
        this.cacheUser(username, user);
        return user;
    }

    private void cacheUser(String username, User user) {
        this.getUserCache().put((Object)username, (Object)(user == null ? NULL_USER : user));
    }

    private void cacheRepository(String username, RepositoryIdentifier repository) {
        this.getRepositoryCache().put((Object)username, (Object)repository);
    }

    private void cacheUserROFlag(User user, boolean ro) {
        this.getUserROFlagCache().put((Object)user.getName(), (Object)ro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getUserCache() {
        CachingUserManager cachingUserManager = this;
        synchronized (cachingUserManager) {
            if (this.userCacheName == null) {
                this.userCacheName = this.getCacheKey(CACHE_SUFFIX_USERS);
            }
        }
        return this.cacheFactory.getCache(this.userCacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getUserROFlagCache() {
        CachingUserManager cachingUserManager = this;
        synchronized (cachingUserManager) {
            if (this.userROCacheName == null) {
                this.userROCacheName = this.getCacheKey(CACHE_SUFFIX_USERS_RO);
            }
        }
        return this.cacheFactory.getCache(this.userROCacheName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cache getRepositoryCache() {
        CachingUserManager cachingUserManager = this;
        synchronized (cachingUserManager) {
            if (this.repositoryCacheName == null) {
                this.repositoryCacheName = this.getCacheKey(CACHE_SUFFIX_REPOSITORIES);
            }
        }
        return this.cacheFactory.getCache(this.repositoryCacheName);
    }

    public User createUser(String username) throws EntityException {
        User user = this.underlyingUserManager.createUser(username);
        if (user != null) {
            this.cacheUser(user.getName(), user);
        }
        return user;
    }

    public User createUser(User userTemplate, Credential credential) throws EntityException {
        User user = this.underlyingUserManager.createUser(userTemplate, credential);
        if (user != null) {
            this.cacheUser(user.getName(), user);
        }
        return user;
    }

    public void alterPassword(User user, String plainTextPass) throws EntityException {
        this.underlyingUserManager.alterPassword(user, plainTextPass);
        if (user != null) {
            this.cacheUser(user.getName(), this.underlyingUserManager.getUser(user.getName()));
        }
    }

    public User renameUser(User user, String userName) throws EntityException {
        User renamedUser = this.underlyingUserManager.renameUser(user, userName);
        this.updateCacheAfterRename(user.getName(), renamedUser);
        return renamedUser;
    }

    public User onExternalUserRename(String oldName, String newName) throws EntityException {
        User renamedUser = this.underlyingUserManager.onExternalUserRename(oldName, newName);
        this.updateCacheAfterRename(oldName, renamedUser);
        return renamedUser;
    }

    private void updateCacheAfterRename(String oldName, User renamedUser) {
        this.getUserCache().remove((Object)oldName);
        if (renamedUser != null) {
            this.cacheUser(renamedUser.getName(), renamedUser);
        }
    }

    public User saveUser(User user) throws EntityException {
        User savedUser = this.underlyingUserManager.saveUser(user);
        if (savedUser != null) {
            this.cacheUser(savedUser.getName(), savedUser);
        }
        return savedUser;
    }

    public void removeUser(User user) throws EntityException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removing user: " + user.getName()));
        }
        this.underlyingUserManager.removeUser(user);
        if (log.isDebugEnabled()) {
            log.debug((Object)("user " + user.getName() + " removed from underlying user manager " + this.underlyingUserManager.getIdentifier().getName()));
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("removing user from cache: " + user.getName()));
            }
            this.removeUserFromCache(user);
            if (log.isDebugEnabled()) {
                log.debug((Object)("removed user from cache: " + user.getName()));
                if (this.getUserCache().get((Object)user.getName()) != null) {
                    log.error((Object)"WTF???");
                }
            }
        }
        catch (Exception e) {
            throw new EntityException("User removed in underlying repository but could not remove from cache");
        }
    }

    private void removeUserFromCache(User user) {
        if (user != null) {
            this.getUserCache().remove((Object)user.getName());
        }
    }

    public boolean isReadOnly(User user) throws EntityException {
        Boolean cachedROFlag = (Boolean)this.getUserROFlagCache().get((Object)user.getName());
        if (cachedROFlag == null) {
            boolean ro = this.underlyingUserManager.isReadOnly(user);
            this.cacheUserROFlag(user, ro);
            return ro;
        }
        return cachedROFlag;
    }

    public RepositoryIdentifier getIdentifier() {
        return this.underlyingUserManager.getIdentifier();
    }

    public RepositoryIdentifier getRepository(@NotNull Entity entity) throws EntityException {
        RepositoryIdentifier cachedRepository = (RepositoryIdentifier)this.getRepositoryCache().get((Object)entity.getName());
        if (cachedRepository != null) {
            return cachedRepository;
        }
        RepositoryIdentifier repository = this.underlyingUserManager.getRepository(entity);
        if (repository != null) {
            this.cacheRepository(entity.getName(), repository);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("UserManager %s does not contain entity %s", this.underlyingUserManager.getIdentifier(), entity.getName()));
        }
        return repository;
    }

    public boolean isCreative() {
        return this.underlyingUserManager.isCreative();
    }

    private String getCacheKey(String cacheName) {
        String className = this.underlyingUserManager.getClass().getName();
        String repositoryKey = this.underlyingUserManager.getIdentifier().getKey();
        return className + "." + repositoryKey + "." + cacheName;
    }
}

