package com.atlassian.user.impl.cache;

import java.util.List;

/**
 * @deprecated since 1.25, use {@link com.atlassian.cache.Cache} instead
 */
public interface Cache
{
    /**
     * The name of the cache uniquely identifies this cache.
     *
     * @return the name of the cache.
     */
    String getName();

    /**
     * Retrieve an object from this cache.
     * @param key uniquely identifying the object to be retrieved.
     *
     * @return the object from the cache, or null if the object is not found.
     */
    Object get(Object key);

    /**
     * Retrieve a list of all of the keys for objects currently stored in this cache.
     *
     * @return a list of keys for each of the objects in this cache.
     *
     * @deprecated this is not supported by all cache implementations and therefore will be removed from this interface
     * in the near future.
     */
    List/*<Object>*/ getKeys();

    /**
     * Put an object into the cache. If the specified key already exists within the cache, it will be replaced by
     * the new object.
     *
     * @param key uniquely identifying the object to be added into the cache.
     * @param value to be cached.
     */
    void put(Object key, Object value);

    /**
     * Remove the object identified by the key from the cache. If no object can be found associated with this key
     * then no action is taken.
     *
     * @param key uniquely identifying the object to be removed.
     */
    void remove(Object key);

    /**
     * Remove all of the objects from this cache.
     */
    void removeAll();

    /**
     * @deprecated The idea of status is not supported by all cache implementations and therefore is likely to be
     * moved into another interface. Do not use this.
     */
    int getStatus();
}
