package com.atlassian.user.impl.ldap.properties.factory;

import com.atlassian.user.impl.ldap.properties.LdapConnectionProperties;
import com.atlassian.user.impl.ldap.properties.DefaultLdapConnectionProperties;
import com.atlassian.user.configuration.Configuration;

import java.util.Properties;

import org.apache.log4j.Logger;

public class LdapConnectionPropertiesFactory
{
    protected final Logger log = Logger.getLogger(this.getClass());

    public LdapConnectionProperties createInstance(Properties properties)
    {
        DefaultLdapConnectionProperties result = new DefaultLdapConnectionProperties();
        result.setHost(properties.getProperty(Configuration.HOST, "localhost"));
        result.setJndiInitialContextFactoryIdentifier(
            properties.getProperty(Configuration.INITIAL_CONTEXT_FACTORY_JNDI));
        result.setPort(getInt(properties, Configuration.PORT,
            DefaultLdapConnectionProperties.DEFAULT_LDAP_PORT, "LDAP server port"));
        result.setSearchBatchSize(getInt(properties, Configuration.BATCH_SIZE,
            DefaultLdapConnectionProperties.DEFAULT_BATCH_SIZE, "LDAP search batch size"));
        result.setConnectTimeoutMillis(getInt(properties, Configuration.CONNECT_TIMEOUT,
            DefaultLdapConnectionProperties.DEFAULT_CONNECT_TIMEOUT_MILLIS, "LDAP connection timeout"));
        result.setReadTimeoutMillis(getInt(properties, Configuration.READ_TIMEOUT,
            DefaultLdapConnectionProperties.DEFAULT_READ_TIMEOUT_MILLIS, "LDAP read timeout"));
        result.setSecurityAuthentication(properties.getProperty(Configuration.AUTHENTICATION, DefaultLdapConnectionProperties.DEFAULT_AUTHENTICATION));
        result.setSecurityCredential(properties.getProperty(Configuration.SECURITY_CREDENTIAL));
        result.setSecurityPrincipal(properties.getProperty(Configuration.SECURITY_PRINCIPAL));
        result.setSecurityProtocol(properties.getProperty(Configuration.SECURITY_PROTOCOL));
        String poolingOn = properties.getProperty(Configuration.POOLING_ON, "true");
        result.setPoolingOn(Boolean.valueOf(poolingOn).booleanValue());
        result.setProviderURL(properties.getProperty(Configuration.PROVIDER_URL));
        return result;
    }

    /**
     * Returns the integer value for the key from the properties, substituting the default value
     * if the key is missing or not an integer. Parsing the string property into an integer is done via
     * {@link Integer#parseInt(String)}.
     *
     * @param properties the properties to retrieve the value from
     * @param key the key to look up
     * @param defaultValue the value returned if the key does not exist in the properties or its value cannot
     * be parsed into an integer by {@link Integer#parseInt(String)}.
     * @param description a description of the key used for logging if the parsing fails
     * @return the integer value of the key in the provided properties or the default value if the key is not found
     * or its value is not a number
     */
    private int getInt(Properties properties, String key, int defaultValue, String description)
    {
        String value = properties.getProperty(key, Integer.toString(defaultValue));
        try
        {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e)
        {
            log.warn("Error parsing " + description + " in configuration file, using default value", e);
            return defaultValue;
        }
    }
}
