package com.atlassian.user.impl.ldap.search;

import net.sf.ldaptemplate.support.filter.Filter;
import com.atlassian.user.Group;
import com.atlassian.user.User;

public interface LdapFilterFactory
{
    /**
     * LDAP getGroupEntries filter suitable for locating groups entries which will be modelled as {@link Group} objects.
     *
     * @return LDAP getGroupEntries filter suitable for locating groups entries which will be modelled as {@link Group}
     *         objects.
     */
    Filter getGroupSearchFilter();

    /**
     * LDAP getGroupEntries filter suitable for locating user entries which will be modelled as {@link User} objects.
     *
     * @return LDAP getGroupEntries filter suitable for locating groups entries which will be modelled as {@link User}
     * objects.
     */
    Filter getUserSearchFilter();
}
