package com.atlassian.user.search.query;

import com.atlassian.user.Entity;

import java.util.List;

/**
 * Allows for the boolean conjunction of {@link Query} objects with an AND or OR parameter.
 *
 * For example, the results of query1 could be ANDED with query2 on the condition that their equality.
 */

public interface BooleanQuery<T extends Entity> extends Query<T>
{
    public static final String AND = "&";
    public static final String OR = "|";

    /**
     * It is impossible for isAND() and isOR() to both return true or false.
     *
     * @return true if the clause is set to AND the two queries.
     */
    boolean isAND();

    /**
     * @return true if the clause is set to OR the two queries
     */
    boolean isOR();

    List<Query<T>> getQueries();
}
