package com.atlassian.user.search.query;

import com.atlassian.user.repository.RepositoryIdentifier;

import java.util.List;

/**
 * Indicates the context in which a query should run.
 */
public interface QueryContext
{
    /**
     * indicates that the Query Context should search in all delegated repositories.
     *
     * @deprecated since 2.1 should not be on the interface, use {@link AllRepositoriesQueryContext} to model this behaviour
     */
    final String ALL_REPOSITORIES = "_all_repositories_";

    /**
     * @deprecated since 2.1 should not be on the interface, use {@link DefaultQueryContext#DefaultQueryContext(RepositoryIdentifier...)}
     */
    void addRepositoryKey(String key);

    /**
     * @deprecated since 2.1 use {@link #contains(RepositoryIdentifier)} instead
     */
    List<String> getRepositoryKeys();

    /**
     * Returns {@code true} if the specified repository is in this query context, otherwise {@code false}.
     *
     * @since 2.1
     */
    boolean contains(RepositoryIdentifier repositoryIdentifier);
}
