package com.atlassian.user.search.query.match;

import org.apache.commons.lang.StringUtils;

/**
 * Matches if {@link StringUtils#equalsIgnoreCase(String, String)} returns true for the arguments,
 * and content is neither null nor an empty string ("").
 */
public class EqualsIgnoreCaseMatcher implements Matcher
{
    public boolean matches(String content, String searchTerm)
    {
        return !StringUtils.isBlank(content) && StringUtils.equalsIgnoreCase(content, searchTerm);
    }
}
