package com.atlassian.user.search.query.match;

/**
 * An interface for matching the contents of a string against a search term. Implements will describe the situations in
 * which they match.
 */
public interface Matcher
{
    /**
     * Returns true if the content "matches" the searchTerm, according to the matching rules of the implementation.
     *
     * @param content the content to search
     * @param searchTerm the term to search for
     * @return <tt>true</tt> if the content matches the search term, according to the matching rules of the
     *         implementation, otherwise <tt>false</tt>.
     */
    boolean matches(String content, String searchTerm);
}
