package com.atlassian.user.util;

import com.opensymphony.util.TextUtils;
import net.sf.ldaptemplate.support.filter.AndFilter;
import net.sf.ldaptemplate.support.filter.Filter;
import org.apache.log4j.Category;

import javax.naming.directory.SearchControls;

public class LDAPUtils
{
    public static final Category log = Category.getInstance(LDAPUtils.class);

    /**
     * "ANDS" the two filters passed in. Either filter may be null, in which case the non-null filter is returned.
     */
    public static Filter makeAndFilter(Filter filter1, Filter filter2)
    {
        if (filter1 == null)
        {
            return filter2;
        }
        if (filter2 == null)
        {
            return filter1;
        }
        return new AndFilter().and(filter1).and(filter2);
    }

    public static boolean isValidFilter(String filter)
    {
        return TextUtils.stringSet(filter) && filter.startsWith("(") && filter.endsWith(")") && filter.indexOf("=") != -1;
    }

    public static SearchControls createSearchControls(String[] attributesToReturn, boolean searchAllDepths, int timeLimitMillis)
    {
        SearchControls ctls = new SearchControls();

        int searchScope = searchAllDepths ? SearchControls.SUBTREE_SCOPE : SearchControls.ONELEVEL_SCOPE;
        ctls.setSearchScope(searchScope);

        if (attributesToReturn != null)
            ctls.setReturningAttributes(attributesToReturn);

        ctls.setTimeLimit(timeLimitMillis);

        return ctls;
    }
}
