/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core;

import com.atlassian.vcache.RequestCache;
import com.atlassian.vcache.internal.NameValidator;
import com.atlassian.vcache.internal.RequestContext;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequestCache<K, V>
implements RequestCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(DefaultRequestCache.class);
    private final String name;
    private final Supplier<RequestContext> contextSupplier;

    public DefaultRequestCache(String name, Supplier<RequestContext> contextSupplier) {
        this.name = NameValidator.requireValidCacheName((String)name);
        this.contextSupplier = Objects.requireNonNull(contextSupplier);
    }

    @Nonnull
    public Optional<V> get(K key) {
        return Optional.ofNullable(this.ensureDelegate().get(key));
    }

    @Nonnull
    public V get(K key, Supplier<? extends V> supplier) {
        return (V)this.ensureDelegate().computeIfAbsent(Objects.requireNonNull(key), k -> Objects.requireNonNull(supplier.get()));
    }

    public void put(K key, V value) {
        this.ensureDelegate().put(Objects.requireNonNull(key), Objects.requireNonNull(value));
    }

    @Nonnull
    public Optional<V> putIfAbsent(K key, V value) {
        return Optional.ofNullable(this.ensureDelegate().putIfAbsent(Objects.requireNonNull(key), Objects.requireNonNull(value)));
    }

    public boolean replaceIf(K key, V currentValue, V newValue) {
        return this.ensureDelegate().replace(Objects.requireNonNull(key), Objects.requireNonNull(currentValue), Objects.requireNonNull(newValue));
    }

    public boolean removeIf(K key, V value) {
        return this.ensureDelegate().remove(Objects.requireNonNull(key), Objects.requireNonNull(value));
    }

    public void remove(K key) {
        this.ensureDelegate().remove(key);
    }

    public void removeAll() {
        this.ensureDelegate().clear();
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    private HashMap<K, V> ensureDelegate() {
        RequestContext requestContext = this.contextSupplier.get();
        return (HashMap)requestContext.computeIfAbsent((Object)this, HashMap::new);
    }
}

