/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core;

import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.annotation.Nonnull;

public class Sha1ExternalCacheKeyGenerator
extends ExternalCacheKeyGenerator {
    private static final String DIGEST_ALGORITHM = "SHA-1";
    private static final Charset DIGEST_CHARSET = StandardCharsets.UTF_8;

    public Sha1ExternalCacheKeyGenerator(String productIdentifier) {
        super(productIdentifier);
    }

    @Override
    @Nonnull
    protected String encode(String plain) {
        try {
            MessageDigest md = MessageDigest.getInstance(DIGEST_ALGORITHM);
            byte[] digest = md.digest(plain.getBytes(DIGEST_CHARSET));
            return Base64.getEncoder().encodeToString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unable to encode to SHA-1", e);
        }
    }
}

