/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core;

import com.atlassian.vcache.internal.NameValidator;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.core.DefaultRequestContext;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalRequestContextSupplier
implements Supplier<RequestContext> {
    private static final Logger log = LoggerFactory.getLogger(ThreadLocalRequestContextSupplier.class);
    private final ThreadLocal<RequestContext> threadRequestContexts = new ThreadLocal();
    private final Optional<Supplier<String>> lenientPartitionIdSupplier;

    private ThreadLocalRequestContextSupplier(Optional<Supplier<String>> lenientPartitionIdSupplier) {
        this.lenientPartitionIdSupplier = Objects.requireNonNull(lenientPartitionIdSupplier);
    }

    @Nonnull
    public static ThreadLocalRequestContextSupplier strictSupplier() {
        return new ThreadLocalRequestContextSupplier(Optional.empty());
    }

    @Nonnull
    public static ThreadLocalRequestContextSupplier lenientSupplier(Supplier<String> partitionIdSupplier) {
        log.warn("A lenient supplier has been created, TransactionalExternalCaches are now broken");
        return new ThreadLocalRequestContextSupplier(Optional.of(partitionIdSupplier));
    }

    @Override
    @Nonnull
    public RequestContext get() {
        RequestContext current = this.threadRequestContexts.get();
        if (current == null) {
            if (!this.lenientPartitionIdSupplier.isPresent()) {
                log.error("Asked for request context when not initialised!");
                throw new IllegalStateException("Thread has not been initialised.");
            }
            log.debug("Asked for request context when not initialised, returning a lenient one.");
            return new LenientRequestContext();
        }
        return current;
    }

    public void initThread(String partitionId) {
        RequestContext current = this.threadRequestContexts.get();
        if (current != null) {
            log.error("Asked to initialise thread {} that is already initialised!", (Object)Thread.currentThread().getName());
            throw new IllegalStateException("Thread '" + Thread.currentThread().getName() + "' has already been initialised.");
        }
        log.trace("Initialise request context");
        this.threadRequestContexts.set(new DefaultRequestContext(NameValidator.requireValidPartitionIdentifier((String)partitionId)));
    }

    public void clearThread() {
        RequestContext current = this.threadRequestContexts.get();
        if (current == null) {
            log.warn("Asked to clear a thread that is already clear!");
        }
        log.trace("Clear request context");
        this.threadRequestContexts.remove();
    }

    private class LenientRequestContext
    implements RequestContext {
        private LenientRequestContext() {
        }

        @Nonnull
        public String partitionIdentifier() {
            return NameValidator.requireValidPartitionIdentifier((String)((String)((Supplier)ThreadLocalRequestContextSupplier.this.lenientPartitionIdSupplier.get()).get()));
        }

        @Nonnull
        public <T> T computeIfAbsent(Object key, Supplier<T> supplier) {
            return supplier.get();
        }

        @Nonnull
        public <T> Optional<T> get(Object key) {
            return Optional.empty();
        }
    }
}

