/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.internal.LongMetric;
import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.RequestMetrics;
import com.atlassian.vcache.internal.core.metrics.CacheType;
import com.atlassian.vcache.internal.core.metrics.DefaultLongMetric;
import com.atlassian.vcache.internal.core.metrics.MutableRequestMetrics;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

class DefaultRequestMetrics
implements MutableRequestMetrics,
RequestMetrics {
    private final EnumMap<CacheType, Map<String, EnumMap<MetricLabel, DefaultLongMetric>>> allMetricsMap = new EnumMap(CacheType.class);

    DefaultRequestMetrics() {
    }

    @Override
    public void record(String cacheName, CacheType cacheType, MetricLabel metricLabel, long sample) {
        Map cacheTypeMetricsMap = this.allMetricsMap.computeIfAbsent(cacheType, k -> new HashMap());
        EnumMap cacheMetricsMap = cacheTypeMetricsMap.computeIfAbsent(cacheName, k -> new EnumMap(MetricLabel.class));
        DefaultLongMetric metric = cacheMetricsMap.computeIfAbsent(metricLabel, k -> new DefaultLongMetric());
        metric.record(sample);
    }

    @Nonnull
    public Map<String, EnumMap<MetricLabel, ? extends LongMetric>> allJvmCacheLongMetrics() {
        return new HashMap<String, EnumMap<MetricLabel, ? extends LongMetric>>(this.allMetricsMap.computeIfAbsent(CacheType.JVM, k -> new HashMap()));
    }

    @Nonnull
    public Map<String, EnumMap<MetricLabel, ? extends LongMetric>> allRequestCacheLongMetrics() {
        return new HashMap<String, EnumMap<MetricLabel, ? extends LongMetric>>(this.allMetricsMap.computeIfAbsent(CacheType.REQUEST, k -> new HashMap()));
    }

    @Nonnull
    public Map<String, EnumMap<MetricLabel, ? extends LongMetric>> allExternalCacheLongMetrics() {
        return new HashMap<String, EnumMap<MetricLabel, ? extends LongMetric>>(this.allMetricsMap.computeIfAbsent(CacheType.EXTERNAL, k -> new HashMap()));
    }
}

