/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.metrics;

import com.atlassian.vcache.CasIdentifier;
import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.ExternalWriteOperationsUnbuffered;
import com.atlassian.vcache.IdentifiedValue;
import com.atlassian.vcache.internal.MetricLabel;
import com.atlassian.vcache.internal.core.VCacheCoreUtils;
import com.atlassian.vcache.internal.core.metrics.CacheType;
import com.atlassian.vcache.internal.core.metrics.ElapsedTimer;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import com.atlassian.vcache.internal.core.metrics.TimedExternalWriteOperationsUnbuffered;
import com.atlassian.vcache.internal.core.metrics.TimedUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import javax.annotation.Nonnull;

class TimedDirectExternalCache<V>
extends TimedExternalWriteOperationsUnbuffered<V>
implements DirectExternalCache<V> {
    private final DirectExternalCache<V> delegate;

    TimedDirectExternalCache(MetricsCollector metricsCollector, DirectExternalCache<V> delegate) {
        super(metricsCollector);
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    @Nonnull
    protected ExternalWriteOperationsUnbuffered<V> getDelegateOps() {
        return this.delegate;
    }

    @Override
    @Nonnull
    protected DirectExternalCache<V> getDelegate() {
        return this.delegate;
    }

    @Nonnull
    public CompletionStage<Optional<IdentifiedValue<V>>> getIdentified(String key) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.TIMED_IDENTIFIED_GET_CALL, t));){
            CompletionStage result = this.getDelegate().getIdentified(key);
            TimedUtils.whenCompletableFuture(result, future -> {
                if (future.isCompletedExceptionally()) {
                    this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_FAILED_IDENTIFIED_GET, 1L);
                } else {
                    Optional rj = (Optional)future.join();
                    this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), rj.isPresent() ? MetricLabel.NUMBER_OF_HITS : MetricLabel.NUMBER_OF_MISSES, 1L);
                }
            });
            CompletionStage completionStage = result;
            return completionStage;
        }
    }

    @Nonnull
    public CompletionStage<Map<String, Optional<IdentifiedValue<V>>>> getBulkIdentified(Iterable<String> keys) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.TIMED_IDENTIFIED_GET_CALL, t));){
            CompletionStage result = this.getDelegate().getBulkIdentified(keys);
            TimedUtils.whenCompletableFuture(result, future -> {
                if (future.isCompletedExceptionally()) {
                    this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_FAILED_IDENTIFIED_GET, 1L);
                } else {
                    Map rj = (Map)future.join();
                    long hits = rj.values().stream().filter(Optional::isPresent).count();
                    VCacheCoreUtils.whenPositive(hits, v -> this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_HITS, v));
                    VCacheCoreUtils.whenPositive((long)rj.size() - hits, v -> this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_MISSES, v));
                }
            });
            CompletionStage completionStage = result;
            return completionStage;
        }
    }

    @Nonnull
    public CompletionStage<Boolean> removeIf(String key, CasIdentifier casId) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.TIMED_IDENTIFIED_REMOVE_CALL, t));){
            CompletionStage result = this.getDelegate().removeIf(key, casId);
            TimedUtils.whenCompletableFuture(result, future -> {
                if (future.isCompletedExceptionally()) {
                    this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_FAILED_IDENTIFIED_REMOVE, 1L);
                }
            });
            CompletionStage completionStage = result;
            return completionStage;
        }
    }

    @Nonnull
    public CompletionStage<Boolean> replaceIf(String key, CasIdentifier casId, V newValue) {
        try (ElapsedTimer ignored = new ElapsedTimer(t -> this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.TIMED_IDENTIFIED_REPLACE_CALL, t));){
            CompletionStage result = this.getDelegate().replaceIf(key, casId, newValue);
            TimedUtils.whenCompletableFuture(result, future -> {
                if (future.isCompletedExceptionally()) {
                    this.metricsCollector.record(CacheType.EXTERNAL, this.getDelegate().getName(), MetricLabel.NUMBER_OF_FAILED_IDENTIFIED_REPLACE, 1L);
                }
            });
            CompletionStage completionStage = result;
            return completionStage;
        }
    }
}

