/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.service;

import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.internal.core.service.OneShotLatch;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public abstract class AbstractLockingJvmCache<K, V>
implements JvmCache<K, V> {
    private final ConcurrentMap<K, OneShotLatch> barriers = new ConcurrentHashMap<K, OneShotLatch>(16);
    private final Lock supplierLock;
    private final Lock removeAllLock;

    public AbstractLockingJvmCache() {
        ReentrantReadWriteLock supplierVsRemoveAllLock = new ReentrantReadWriteLock(true);
        this.supplierLock = supplierVsRemoveAllLock.readLock();
        this.removeAllLock = supplierVsRemoveAllLock.writeLock();
    }

    @Nonnull
    protected abstract V decoratedGet(K var1, Supplier<? extends V> var2);

    protected abstract void decoratedRemove(K var1);

    protected abstract void decoratedRemoveAll();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public final V get(K key, Supplier<? extends V> supplier) {
        boolean[] mustUnlock = new boolean[1];
        try {
            Object object = this.decoratedGet(key, () -> {
                mustUnlock[0] = true;
                this.acquireLockFor(key);
                this.supplierLock.lock();
                return supplier.get();
            });
            return (V)object;
        }
        finally {
            if (mustUnlock[0]) {
                this.supplierLock.unlock();
                this.releaseLockFor(key);
            }
        }
    }

    public final void remove(K key) {
        this.acquireLockFor(key);
        try {
            this.decoratedRemove(key);
        }
        finally {
            this.releaseLockFor(key);
        }
    }

    public final void removeAll() {
        this.removeAllLock.lock();
        try {
            this.decoratedRemoveAll();
        }
        finally {
            this.removeAllLock.unlock();
        }
    }

    private OneShotLatch acquireLockFor(@Nonnull K key) {
        OneShotLatch barrier = new OneShotLatch();
        OneShotLatch existing;
        while ((existing = this.barriers.putIfAbsent(key, barrier)) != null) {
            existing.await();
        }
        return barrier;
    }

    private void releaseLockFor(K key) {
        OneShotLatch barrier = (OneShotLatch)this.barriers.get(key);
        if (barrier != null && barrier.isHeldByCurrentThread()) {
            this.barriers.remove(key);
            barrier.release();
        }
    }
}

