/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.service;

import com.atlassian.vcache.MarshallerException;
import com.atlassian.vcache.internal.core.VCacheCoreUtils;
import com.atlassian.vcache.internal.core.service.AbstractExternalCache;
import com.atlassian.vcache.internal.core.service.AbstractExternalCacheRequestContext;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

public abstract class AbstractNonDirectExternalCache<V>
extends AbstractExternalCache<V> {
    protected AbstractNonDirectExternalCache(String name) {
        super(name);
    }

    @Nonnull
    protected abstract V handleCreation(String var1, Supplier<V> var2) throws MarshallerException, ExecutionException, InterruptedException;

    @Nonnull
    protected abstract Map<String, V> handleCreation(Function<Set<String>, Map<String, V>> var1, Set<String> var2) throws ExecutionException, InterruptedException;

    @Nonnull
    protected abstract Optional<Optional<V>> checkValueRecorded(String var1);

    @Nonnull
    protected abstract Map<String, Optional<V>> checkValuesRecorded(Iterable<String> var1);

    @Nonnull
    protected abstract Optional<V> directGet(String var1);

    @Nonnull
    protected abstract Map<String, Optional<V>> directGetBulk(Set<String> var1);

    @Nonnull
    public final CompletionStage<Optional<V>> get(String internalKey) {
        return this.perform(() -> {
            AbstractExternalCacheRequestContext cacheContext = this.ensureCacheContext();
            Optional<Optional<V>> prior = this.checkValueRecorded(internalKey);
            return prior.orElseGet(() -> {
                String externalKey = cacheContext.externalEntryKeyFor(internalKey);
                Optional<V> result = this.directGet(externalKey);
                cacheContext.recordValue(internalKey, result);
                return result;
            });
        });
    }

    @Nonnull
    public final CompletionStage<V> get(String internalKey, Supplier<V> supplier) {
        return this.perform(() -> {
            AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            Optional<Optional<V>> prior = this.checkValueRecorded(internalKey);
            if (prior.isPresent()) {
                if (prior.get().isPresent()) {
                    return prior.get().get();
                }
                this.getLogger().trace("Cache {}, creating candidate for key {}", (Object)this.name, (Object)internalKey);
                return this.handleCreation(internalKey, supplier);
            }
            String externalKey = cacheContext.externalEntryKeyFor(internalKey);
            Optional<V> result = this.directGet(externalKey);
            if (result.isPresent()) {
                cacheContext.recordValue(internalKey, result);
                return result.get();
            }
            this.getLogger().trace("Cache {}, creating candidate for key {}", (Object)this.name, (Object)internalKey);
            return this.handleCreation(internalKey, supplier);
        });
    }

    @Nonnull
    public final CompletionStage<Map<String, Optional<V>>> getBulk(Iterable<String> internalKeys) {
        return this.perform(() -> {
            if (VCacheCoreUtils.isEmpty(internalKeys)) {
                return new HashMap();
            }
            AbstractExternalCacheRequestContext cacheContext = this.ensureCacheContext();
            Map grandResult = this.checkValuesRecorded(internalKeys);
            Set<String> missingExternalKeys = StreamSupport.stream(internalKeys.spliterator(), false).filter(k -> !grandResult.containsKey(k)).map(cacheContext::externalEntryKeyFor).collect(Collectors.toSet());
            if (missingExternalKeys.isEmpty()) {
                this.getLogger().trace("Cache {}: getBulk(): have all the requested entries cached", (Object)this.name);
                return grandResult;
            }
            this.getLogger().trace("Cache {}: getBulk(): not cached {} requested entries", (Object)this.name, (Object)missingExternalKeys.size());
            Map<String, Optional<V>> candidateValues = this.directGetBulk(missingExternalKeys);
            return candidateValues.entrySet().stream().collect(() -> grandResult, (m, e) -> {
                Optional result = (Optional)e.getValue();
                cacheContext.recordValue(cacheContext.internalEntryKeyFor((String)e.getKey()), result);
                m.put(cacheContext.internalEntryKeyFor((String)e.getKey()), result);
            }, Map::putAll);
        });
    }

    @Nonnull
    public final CompletionStage<Map<String, V>> getBulk(Function<Set<String>, Map<String, V>> factory, Iterable<String> internalKeys) {
        return this.perform(() -> {
            if (VCacheCoreUtils.isEmpty(internalKeys)) {
                return new HashMap();
            }
            AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            Map<String, Object> grandResult = this.checkValuesRecorded(internalKeys).entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent()).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Optional)e.getValue()).get()));
            Set<String> candidateMissingExternalKeys = StreamSupport.stream(internalKeys.spliterator(), false).filter(k -> !grandResult.containsKey(k)).map(cacheContext::externalEntryKeyFor).collect(Collectors.toSet());
            if (candidateMissingExternalKeys.isEmpty()) {
                this.getLogger().trace("Cache {}: getBulk(Function): had all the requested entries cached", (Object)this.name);
                return grandResult;
            }
            this.getLogger().trace("Cache {}: getBulk(Function): checking external cache for {} keys", (Object)this.name, (Object)candidateMissingExternalKeys.size());
            Map<String, V> missingValues = this.handleCreation(factory, candidateMissingExternalKeys);
            cacheContext.recordValues(missingValues);
            grandResult.putAll(missingValues);
            return grandResult;
        });
    }
}

