/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.service;

import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.MarshallerException;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.TransactionalExternalCache;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.core.TransactionControl;
import com.atlassian.vcache.internal.core.service.AbstractExternalCacheRequestContext;
import com.atlassian.vcache.internal.core.service.AbstractNonDirectExternalCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public abstract class AbstractTransactionalExternalCache<V>
extends AbstractNonDirectExternalCache<V>
implements TransactionalExternalCache<V>,
TransactionControl {
    protected final Supplier<RequestContext> contextSupplier;

    protected AbstractTransactionalExternalCache(String name, Supplier<RequestContext> contextSupplier) {
        super(name);
        this.contextSupplier = Objects.requireNonNull(contextSupplier);
    }

    public final void put(String internalKey, V value, PutPolicy policy) {
        AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        cacheContext.recordPut(internalKey, value, policy);
    }

    public final void remove(Iterable<String> internalKeys) {
        AbstractExternalCacheRequestContext cacheContext = this.ensureCacheContext();
        cacheContext.recordRemove(internalKeys);
    }

    public final void removeAll() {
        AbstractExternalCacheRequestContext cacheContext = this.ensureCacheContext();
        cacheContext.recordRemoveAll();
    }

    @Override
    public final boolean transactionDiscard() {
        RequestContext requestContext = this.contextSupplier.get();
        Optional cacheRequestContext = requestContext.get((Object)this);
        if (!cacheRequestContext.isPresent()) {
            return false;
        }
        boolean hasPendingOperations = ((AbstractExternalCacheRequestContext)cacheRequestContext.get()).hasPendingOperations();
        ((AbstractExternalCacheRequestContext)cacheRequestContext.get()).forgetAll();
        return hasPendingOperations;
    }

    @Override
    @Nonnull
    protected final Optional<Optional<V>> checkValueRecorded(String internalKey) {
        AbstractExternalCacheRequestContext cacheContext = this.ensureCacheContext();
        Optional prior = cacheContext.getValueRecorded(internalKey);
        if (prior.isPresent()) {
            return prior;
        }
        if (cacheContext.hasRemoveAll()) {
            cacheContext.recordValue(internalKey, Optional.empty());
            return Optional.of(Optional.empty());
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    protected final Map<String, Optional<V>> checkValuesRecorded(Iterable<String> internalKeys) {
        AbstractExternalCacheRequestContext cacheContext = this.ensureCacheContext();
        HashMap result = new HashMap();
        internalKeys.forEach(k -> {
            Optional valueRecorded = cacheContext.getValueRecorded((String)k);
            if (valueRecorded.isPresent()) {
                result.put((String)k, valueRecorded.get());
            } else if (cacheContext.hasRemoveAll()) {
                result.put((String)k, Optional.empty());
            }
        });
        return result;
    }

    @Override
    @Nonnull
    protected final V handleCreation(String internalKey, Supplier<V> supplier) throws MarshallerException, ExecutionException, InterruptedException {
        AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        V suppliedValue = Objects.requireNonNull(supplier.get());
        cacheContext.recordPut(internalKey, suppliedValue, PutPolicy.ADD_ONLY);
        return suppliedValue;
    }

    @Override
    @Nonnull
    protected final Map<String, V> handleCreation(Function<Set<String>, Map<String, V>> factory, Set<String> externalKeys) throws ExecutionException, InterruptedException {
        AbstractExternalCacheRequestContext cacheContext = this.ensureCacheContext();
        Map<Object, Object> candidateValues = cacheContext.hasRemoveAll() ? new HashMap() : this.directGetBulk(externalKeys);
        Set<String> missingExternalKeys = cacheContext.hasRemoveAll() ? externalKeys : candidateValues.entrySet().stream().filter(e -> !((Optional)e.getValue()).isPresent()).map(Map.Entry::getKey).collect(Collectors.toSet());
        Map<String, Object> grandResult = candidateValues.entrySet().stream().filter(e -> ((Optional)e.getValue()).isPresent()).collect(Collectors.toMap(e -> cacheContext.internalEntryKeyFor((String)e.getKey()), e -> ((Optional)e.getValue()).get()));
        if (!missingExternalKeys.isEmpty()) {
            this.getLogger().trace("Cache {}: getBulk(Function): calling factory to create {} values", (Object)this.name, (Object)missingExternalKeys.size());
            Set missingInternalKeys = Collections.unmodifiableSet(missingExternalKeys.stream().map(cacheContext::internalEntryKeyFor).collect(Collectors.toSet()));
            Map<String, V> missingValues = factory.apply(missingInternalKeys);
            if (missingInternalKeys.size() != missingValues.size()) {
                this.getLogger().warn("Cache {}: getBulk(Function): mismatch on generated values, expected ", (Object)this.name, (Object)(missingInternalKeys.size() + " but got " + missingValues.size()));
                throw new ExternalCacheException(ExternalCacheException.Reason.FUNCTION_INCORRECT_RESULT);
            }
            missingValues.entrySet().forEach(e -> this.put((String)e.getKey(), e.getValue(), PutPolicy.ADD_ONLY));
            grandResult.putAll(missingValues);
        }
        return grandResult;
    }
}

