/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.core.service;

import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.service.AbstractExternalCacheRequestContext;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class VersionedExternalCacheRequestContext<V>
extends AbstractExternalCacheRequestContext<V> {
    protected final String externalCacheVersionKey;
    private Optional<Long> cacheVersion = Optional.empty();

    public VersionedExternalCacheRequestContext(ExternalCacheKeyGenerator keyGenerator, String name, Supplier<String> partitionSupplier) {
        super(keyGenerator, name, partitionSupplier);
        this.externalCacheVersionKey = keyGenerator.cacheVersionKey(partitionSupplier.get(), name);
    }

    @Override
    protected long cacheVersion() {
        return this.cacheVersion.get();
    }

    public void updateCacheVersion(long value) {
        this.cacheVersion = Optional.of(value);
        this.clearKeyMaps();
    }

    @Nonnull
    public String externalCacheVersionKey() {
        return this.externalCacheVersionKey;
    }
}

