// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * A single instance of additional context information available when Azure OpenAI chat extensions are involved
 * in the generation of a corresponding chat completions response. This context information is only populated when
 * using an Azure OpenAI request configured to use a matching extension.
 */
@Immutable
public final class AzureChatExtensionDataSourceResponseCitation {

    /*
     * The content of the citation.
     */
    @Generated
    @JsonProperty(value = "content")
    private String content;

    /*
     * The title of the citation.
     */
    @Generated
    @JsonProperty(value = "title")
    private String title;

    /*
     * The URL of the citation.
     */
    @Generated
    @JsonProperty(value = "url")
    private String url;

    /*
     * The file path of the citation.
     */
    @Generated
    @JsonProperty(value = "filepath")
    private String filepath;

    /*
     * The chunk ID of the citation.
     */
    @Generated
    @JsonProperty(value = "chunk_id")
    private String chunkId;

    /**
     * Creates an instance of AzureChatExtensionDataSourceResponseCitation class.
     *
     * @param content the content value to set.
     */
    @Generated
    @JsonCreator
    private AzureChatExtensionDataSourceResponseCitation(@JsonProperty(value = "content") String content) {
        this.content = content;
    }

    /**
     * Get the content property: The content of the citation.
     *
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the title property: The title of the citation.
     *
     * @return the title value.
     */
    @Generated
    public String getTitle() {
        return this.title;
    }

    /**
     * Get the url property: The URL of the citation.
     *
     * @return the url value.
     */
    @Generated
    public String getUrl() {
        return this.url;
    }

    /**
     * Get the filepath property: The file path of the citation.
     *
     * @return the filepath value.
     */
    @Generated
    public String getFilepath() {
        return this.filepath;
    }

    /**
     * Get the chunkId property: The chunk ID of the citation.
     *
     * @return the chunkId value.
     */
    @Generated
    public String getChunkId() {
        return this.chunkId;
    }
}
