// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A span object that represents a detected object and its bounding box information.
 */
@Immutable
public final class AzureGroundingEnhancementLineSpan {

    /*
     * The text content of the span that represents the detected object.
     */
    @Generated
    @JsonProperty(value = "text")
    private String text;

    /*
     * The character offset within the text where the span begins. This offset is defined as the position of the first
     * character of the span, counting from the start of the text as Unicode codepoints.
     */
    @Generated
    @JsonProperty(value = "offset")
    private int offset;

    /*
     * The length of the span in characters, measured in Unicode codepoints.
     */
    @Generated
    @JsonProperty(value = "length")
    private int length;

    /*
     * An array of objects representing points in the polygon that encloses the detected object.
     */
    @Generated
    @JsonProperty(value = "polygon")
    private List<AzureGroundingEnhancementCoordinatePoint> polygon;

    /**
     * Creates an instance of AzureGroundingEnhancementLineSpan class.
     *
     * @param text the text value to set.
     * @param offset the offset value to set.
     * @param length the length value to set.
     * @param polygon the polygon value to set.
     */
    @Generated
    @JsonCreator
    private AzureGroundingEnhancementLineSpan(@JsonProperty(value = "text") String text,
        @JsonProperty(value = "offset") int offset, @JsonProperty(value = "length") int length,
        @JsonProperty(value = "polygon") List<AzureGroundingEnhancementCoordinatePoint> polygon) {
        this.text = text;
        this.offset = offset;
        this.length = length;
        this.polygon = polygon;
    }

    /**
     * Get the text property: The text content of the span that represents the detected object.
     *
     * @return the text value.
     */
    @Generated
    public String getText() {
        return this.text;
    }

    /**
     * Get the offset property: The character offset within the text where the span begins. This offset is defined as
     * the position of the first
     * character of the span, counting from the start of the text as Unicode codepoints.
     *
     * @return the offset value.
     */
    @Generated
    public int getOffset() {
        return this.offset;
    }

    /**
     * Get the length property: The length of the span in characters, measured in Unicode codepoints.
     *
     * @return the length value.
     */
    @Generated
    public int getLength() {
        return this.length;
    }

    /**
     * Get the polygon property: An array of objects representing points in the polygon that encloses the detected
     * object.
     *
     * @return the polygon value.
     */
    @Generated
    public List<AzureGroundingEnhancementCoordinatePoint> getPolygon() {
        return this.polygon;
    }
}
