// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The representation of a single prompt completion as part of an overall chat completions request.
 * Generally, `n` choices are generated per provided prompt with a default value of 1.
 * Token limits and other settings may limit the number of choices generated.
 */
@Immutable
public final class ChatChoice {

    /*
     * The chat message for a given chat completions prompt.
     */
    @Generated
    @JsonProperty(value = "message")
    private ChatResponseMessage message;

    /*
     * The ordered index associated with this chat completions choice.
     */
    @Generated
    @JsonProperty(value = "index")
    private int index;

    /*
     * The reason that this chat completions choice completed its generated.
     */
    @Generated
    @JsonProperty(value = "finish_reason")
    private CompletionsFinishReason finishReason;

    /*
     * The delta message content for a streaming response.
     */
    @Generated
    @JsonProperty(value = "delta")
    private ChatResponseMessage delta;

    /**
     * Get the message property: The chat message for a given chat completions prompt.
     *
     * @return the message value.
     */
    @Generated
    public ChatResponseMessage getMessage() {
        return this.message;
    }

    /**
     * Get the index property: The ordered index associated with this chat completions choice.
     *
     * @return the index value.
     */
    @Generated
    public int getIndex() {
        return this.index;
    }

    /**
     * Get the finishReason property: The reason that this chat completions choice completed its generated.
     *
     * @return the finishReason value.
     */
    @Generated
    public CompletionsFinishReason getFinishReason() {
        return this.finishReason;
    }

    /**
     * Get the delta property: The delta message content for a streaming response.
     *
     * @return the delta value.
     */
    @Generated
    public ChatResponseMessage getDelta() {
        return this.delta;
    }

    /*
     * Information about the content filtering category (hate, sexual, violence, self_harm), if it
     * has been detected, as well as the severity level (very_low, low, medium, high-scale that
     * determines the intensity and risk level of harmful content) and if it has been filtered or not.
     */
    @Generated
    @JsonProperty(value = "content_filter_results")
    private ContentFilterResultsForChoice contentFilterResults;

    /**
     * Get the contentFilterResults property: Information about the content filtering category (hate, sexual, violence,
     * self_harm), if it
     * has been detected, as well as the severity level (very_low, low, medium, high-scale that
     * determines the intensity and risk level of harmful content) and if it has been filtered or not.
     *
     * @return the contentFilterResults value.
     */
    @Generated
    public ContentFilterResultsForChoice getContentFilterResults() {
        return this.contentFilterResults;
    }

    /*
     * The reason the model stopped generating tokens, together with any applicable details.
     * This structured representation replaces 'finish_reason' for some models.
     */
    @Generated
    @JsonProperty(value = "finish_details")
    private ChatFinishDetails finishDetails;

    /*
     * Represents the output results of Azure OpenAI enhancements to chat completions, as configured via the matching
     * input
     * provided in the request. This supplementary information is only available when using Azure OpenAI and only when
     * the
     * request is configured to use enhancements.
     */
    @Generated
    @JsonProperty(value = "enhancements")
    private AzureChatEnhancements enhancements;

    /**
     * Get the finishDetails property: The reason the model stopped generating tokens, together with any applicable
     * details.
     * This structured representation replaces 'finish_reason' for some models.
     *
     * @return the finishDetails value.
     */
    @Generated
    public ChatFinishDetails getFinishDetails() {
        return this.finishDetails;
    }

    /**
     * Get the enhancements property: Represents the output results of Azure OpenAI enhancements to chat completions,
     * as configured via the matching input
     * provided in the request. This supplementary information is only available when using Azure OpenAI and only when
     * the
     * request is configured to use enhancements.
     *
     * @return the enhancements value.
     */
    @Generated
    public AzureChatEnhancements getEnhancements() {
        return this.enhancements;
    }

    /*
     * The log probability information for this choice, as enabled via the 'logprobs' request option.
     */
    @Generated
    @JsonProperty(value = "logprobs")
    private ChatChoiceLogProbabilityInfo logprobs;

    /**
     * Creates an instance of ChatChoice class.
     *
     * @param logprobs the logprobs value to set.
     * @param index the index value to set.
     * @param finishReason the finishReason value to set.
     */
    @Generated
    @JsonCreator
    private ChatChoice(@JsonProperty(value = "logprobs") ChatChoiceLogProbabilityInfo logprobs,
        @JsonProperty(value = "index") int index,
        @JsonProperty(value = "finish_reason") CompletionsFinishReason finishReason) {
        this.logprobs = logprobs;
        this.index = index;
        this.finishReason = finishReason;
    }

    /**
     * Get the logprobs property: The log probability information for this choice, as enabled via the 'logprobs'
     * request option.
     *
     * @return the logprobs value.
     */
    @Generated
    public ChatChoiceLogProbabilityInfo getLogprobs() {
        return this.logprobs;
    }
}
