// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A structured chat content item containing an image reference.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("image_url")
@Immutable
public final class ChatMessageImageContentItem extends ChatMessageContentItem {

    /*
     * An internet location, which must be accessible to the model,from which the image may be retrieved.
     */
    @Generated
    @JsonProperty(value = "image_url")
    private ChatMessageImageUrl imageUrl;

    /**
     * Creates an instance of ChatMessageImageContentItem class.
     *
     * @param imageUrl the imageUrl value to set.
     */
    @Generated
    @JsonCreator
    public ChatMessageImageContentItem(@JsonProperty(value = "image_url") ChatMessageImageUrl imageUrl) {
        this.imageUrl = imageUrl;
    }

    /**
     * Get the imageUrl property: An internet location, which must be accessible to the model,from which the image may
     * be retrieved.
     *
     * @return the imageUrl value.
     */
    @Generated
    public ChatMessageImageUrl getImageUrl() {
        return this.imageUrl;
    }
}
