// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A request chat message representing requested output from a configured tool.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "role")
@JsonTypeName("tool")
@Immutable
public final class ChatRequestToolMessage extends ChatRequestMessage {

    /*
     * The content of the message.
     */
    @Generated
    @JsonProperty(value = "content")
    private String content;

    /*
     * The ID of the tool call resolved by the provided content.
     */
    @Generated
    @JsonProperty(value = "tool_call_id")
    private String toolCallId;

    /**
     * Creates an instance of ChatRequestToolMessage class.
     *
     * @param content the content value to set.
     * @param toolCallId the toolCallId value to set.
     */
    @Generated
    @JsonCreator
    public ChatRequestToolMessage(@JsonProperty(value = "content") String content,
        @JsonProperty(value = "tool_call_id") String toolCallId) {
        this.content = content;
        this.toolCallId = toolCallId;
    }

    /**
     * Get the content property: The content of the message.
     *
     * @return the content value.
     */
    @Generated
    public String getContent() {
        return this.content;
    }

    /**
     * Get the toolCallId property: The ID of the tool call resolved by the provided content.
     *
     * @return the toolCallId value.
     */
    @Generated
    public String getToolCallId() {
        return this.toolCallId;
    }
}
