// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * A representation of the log probability information for a single message content token.
 */
@Immutable
public final class ChatTokenLogProbabilityInfo {

    /*
     * The message content token.
     */
    @Generated
    @JsonProperty(value = "token")
    private String token;

    /*
     * The log probability of the message content token.
     */
    @Generated
    @JsonProperty(value = "logprob")
    private double logprob;

    /*
     * A list of integers representing the UTF-8 bytes representation of the token. Useful in instances where
     * characters are represented by multiple tokens and their byte representations must be combined to generate the
     * correct text representation. Can be null if there is no bytes representation for the token.
     */
    @Generated
    @JsonProperty(value = "bytes")
    private List<Integer> bytes;

    /**
     * Creates an instance of ChatTokenLogProbabilityInfo class.
     *
     * @param token the token value to set.
     * @param logprob the logprob value to set.
     * @param bytes the bytes value to set.
     */
    @Generated
    @JsonCreator
    private ChatTokenLogProbabilityInfo(@JsonProperty(value = "token") String token,
        @JsonProperty(value = "logprob") double logprob, @JsonProperty(value = "bytes") List<Integer> bytes) {
        this.token = token;
        this.logprob = logprob;
        this.bytes = bytes;
    }

    /**
     * Get the token property: The message content token.
     *
     * @return the token value.
     */
    @Generated
    public String getToken() {
        return this.token;
    }

    /**
     * Get the logprob property: The log probability of the message content token.
     *
     * @return the logprob value.
     */
    @Generated
    public double getLogprob() {
        return this.logprob;
    }

    /**
     * Get the bytes property: A list of integers representing the UTF-8 bytes representation of the token. Useful in
     * instances where characters are represented by multiple tokens and their byte representations must be combined to
     * generate the correct text representation. Can be null if there is no bytes representation for the token.
     *
     * @return the bytes value.
     */
    @Generated
    public List<Integer> getBytes() {
        return this.bytes;
    }
}
