// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Content filtering results for a single prompt in the request.
 */
@Immutable
public final class ContentFilterResultsForPrompt {

    /*
     * The index of this prompt in the set of prompt results
     */
    @Generated
    @JsonProperty(value = "prompt_index")
    private int promptIndex;

    /*
     * Content filtering results for this prompt
     */
    @Generated
    @JsonProperty(value = "content_filter_results")
    private ContentFilterResultDetailsForPrompt contentFilterResults;

    /**
     * Get the promptIndex property: The index of this prompt in the set of prompt results.
     *
     * @return the promptIndex value.
     */
    @Generated
    public int getPromptIndex() {
        return this.promptIndex;
    }

    /**
     * Get the contentFilterResults property: Content filtering results for this prompt.
     *
     * @return the contentFilterResults value.
     */
    @Generated
    public ContentFilterResultDetailsForPrompt getContentFilterResults() {
        return this.contentFilterResults;
    }

    /**
     * Creates an instance of ContentFilterResultsForPrompt class.
     *
     * @param promptIndex the promptIndex value to set.
     * @param contentFilterResults the contentFilterResults value to set.
     */
    @Generated
    @JsonCreator
    private ContentFilterResultsForPrompt(@JsonProperty(value = "prompt_index") int promptIndex,
        @JsonProperty(value = "content_filter_results") ContentFilterResultDetailsForPrompt contentFilterResults) {
        this.promptIndex = promptIndex;
        this.contentFilterResults = contentFilterResults;
    }
}
