// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Parameters to use when configuring Elasticsearch® as an Azure OpenAI chat extension. The supported authentication
 * types are KeyAndKeyId and EncodedAPIKey.
 */
@Fluent
public final class ElasticsearchChatExtensionParameters {

    /*
     * The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     */
    @Generated
    @JsonProperty(value = "authentication")
    private OnYourDataAuthenticationOptions authentication;

    /*
     * The configured top number of documents to feature for the configured query.
     */
    @Generated
    @JsonProperty(value = "top_n_documents")
    private Integer topNDocuments;

    /*
     * Whether queries should be restricted to use of indexed data.
     */
    @Generated
    @JsonProperty(value = "in_scope")
    private Boolean inScope;

    /*
     * The configured strictness of the search relevance filtering. The higher of strictness, the higher of the
     * precision but lower recall of the answer.
     */
    @Generated
    @JsonProperty(value = "strictness")
    private Integer strictness;

    /*
     * Give the model instructions about how it should behave and any context it should reference when generating a
     * response. You can describe the assistant's personality and tell it how to format responses. There's a 100 token
     * limit for it, and it counts against the overall token limit.
     */
    @Generated
    @JsonProperty(value = "role_information")
    private String roleInformation;

    /*
     * The endpoint of Elasticsearch®.
     */
    @Generated
    @JsonProperty(value = "endpoint")
    private String endpoint;

    /*
     * The index name of Elasticsearch®.
     */
    @Generated
    @JsonProperty(value = "index_name")
    private String indexName;

    /*
     * The index field mapping options of Elasticsearch®.
     */
    @Generated
    @JsonProperty(value = "fields_mapping")
    private ElasticsearchIndexFieldMappingOptions fieldsMapping;

    /*
     * The query type of Elasticsearch®.
     */
    @Generated
    @JsonProperty(value = "query_type")
    private ElasticsearchQueryType queryType;

    /*
     * The embedding dependency for vector search.
     */
    @Generated
    @JsonProperty(value = "embedding_dependency")
    private OnYourDataVectorizationSource embeddingDependency;

    /**
     * Creates an instance of ElasticsearchChatExtensionParameters class.
     *
     * @param endpoint the endpoint value to set.
     * @param indexName the indexName value to set.
     */
    @Generated
    @JsonCreator
    public ElasticsearchChatExtensionParameters(@JsonProperty(value = "endpoint") String endpoint,
        @JsonProperty(value = "index_name") String indexName) {
        this.endpoint = endpoint;
        this.indexName = indexName;
    }

    /**
     * Get the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @return the authentication value.
     */
    @Generated
    public OnYourDataAuthenticationOptions getAuthentication() {
        return this.authentication;
    }

    /**
     * Set the authentication property: The authentication method to use when accessing the defined data source.
     * Each data source type supports a specific set of available authentication methods; please see the documentation
     * of
     * the data source for supported mechanisms.
     * If not otherwise provided, On Your Data will attempt to use System Managed Identity (default credential)
     * authentication.
     *
     * @param authentication the authentication value to set.
     * @return the ElasticsearchChatExtensionParameters object itself.
     */
    @Generated
    public ElasticsearchChatExtensionParameters setAuthentication(OnYourDataAuthenticationOptions authentication) {
        this.authentication = authentication;
        return this;
    }

    /**
     * Get the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @return the topNDocuments value.
     */
    @Generated
    public Integer getTopNDocuments() {
        return this.topNDocuments;
    }

    /**
     * Set the topNDocuments property: The configured top number of documents to feature for the configured query.
     *
     * @param topNDocuments the topNDocuments value to set.
     * @return the ElasticsearchChatExtensionParameters object itself.
     */
    @Generated
    public ElasticsearchChatExtensionParameters setTopNDocuments(Integer topNDocuments) {
        this.topNDocuments = topNDocuments;
        return this;
    }

    /**
     * Get the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @return the inScope value.
     */
    @Generated
    public Boolean isInScope() {
        return this.inScope;
    }

    /**
     * Set the inScope property: Whether queries should be restricted to use of indexed data.
     *
     * @param inScope the inScope value to set.
     * @return the ElasticsearchChatExtensionParameters object itself.
     */
    @Generated
    public ElasticsearchChatExtensionParameters setInScope(Boolean inScope) {
        this.inScope = inScope;
        return this;
    }

    /**
     * Get the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @return the strictness value.
     */
    @Generated
    public Integer getStrictness() {
        return this.strictness;
    }

    /**
     * Set the strictness property: The configured strictness of the search relevance filtering. The higher of
     * strictness, the higher of the precision but lower recall of the answer.
     *
     * @param strictness the strictness value to set.
     * @return the ElasticsearchChatExtensionParameters object itself.
     */
    @Generated
    public ElasticsearchChatExtensionParameters setStrictness(Integer strictness) {
        this.strictness = strictness;
        return this;
    }

    /**
     * Get the roleInformation property: Give the model instructions about how it should behave and any context it
     * should reference when generating a response. You can describe the assistant's personality and tell it how to
     * format responses. There's a 100 token limit for it, and it counts against the overall token limit.
     *
     * @return the roleInformation value.
     */
    @Generated
    public String getRoleInformation() {
        return this.roleInformation;
    }

    /**
     * Set the roleInformation property: Give the model instructions about how it should behave and any context it
     * should reference when generating a response. You can describe the assistant's personality and tell it how to
     * format responses. There's a 100 token limit for it, and it counts against the overall token limit.
     *
     * @param roleInformation the roleInformation value to set.
     * @return the ElasticsearchChatExtensionParameters object itself.
     */
    @Generated
    public ElasticsearchChatExtensionParameters setRoleInformation(String roleInformation) {
        this.roleInformation = roleInformation;
        return this;
    }

    /**
     * Get the endpoint property: The endpoint of Elasticsearch®.
     *
     * @return the endpoint value.
     */
    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    /**
     * Get the indexName property: The index name of Elasticsearch®.
     *
     * @return the indexName value.
     */
    @Generated
    public String getIndexName() {
        return this.indexName;
    }

    /**
     * Get the fieldsMapping property: The index field mapping options of Elasticsearch®.
     *
     * @return the fieldsMapping value.
     */
    @Generated
    public ElasticsearchIndexFieldMappingOptions getFieldsMapping() {
        return this.fieldsMapping;
    }

    /**
     * Set the fieldsMapping property: The index field mapping options of Elasticsearch®.
     *
     * @param fieldsMapping the fieldsMapping value to set.
     * @return the ElasticsearchChatExtensionParameters object itself.
     */
    @Generated
    public ElasticsearchChatExtensionParameters setFieldsMapping(ElasticsearchIndexFieldMappingOptions fieldsMapping) {
        this.fieldsMapping = fieldsMapping;
        return this;
    }

    /**
     * Get the queryType property: The query type of Elasticsearch®.
     *
     * @return the queryType value.
     */
    @Generated
    public ElasticsearchQueryType getQueryType() {
        return this.queryType;
    }

    /**
     * Set the queryType property: The query type of Elasticsearch®.
     *
     * @param queryType the queryType value to set.
     * @return the ElasticsearchChatExtensionParameters object itself.
     */
    @Generated
    public ElasticsearchChatExtensionParameters setQueryType(ElasticsearchQueryType queryType) {
        this.queryType = queryType;
        return this;
    }

    /**
     * Get the embeddingDependency property: The embedding dependency for vector search.
     *
     * @return the embeddingDependency value.
     */
    @Generated
    public OnYourDataVectorizationSource getEmbeddingDependency() {
        return this.embeddingDependency;
    }

    /**
     * Set the embeddingDependency property: The embedding dependency for vector search.
     *
     * @param embeddingDependency the embeddingDependency value to set.
     * @return the ElasticsearchChatExtensionParameters object itself.
     */
    @Generated
    public ElasticsearchChatExtensionParameters
        setEmbeddingDependency(OnYourDataVectorizationSource embeddingDependency) {
        this.embeddingDependency = embeddingDependency;
        return this;
    }
}
