// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Representation of the response data from an embeddings request.
 * Embeddings measure the relatedness of text strings and are commonly used for search, clustering,
 * recommendations, and other similar scenarios.
 */
@Immutable
public final class Embeddings {

    /*
     * Embedding values for the prompts submitted in the request.
     */
    @Generated
    @JsonProperty(value = "data")
    private List<EmbeddingItem> data;

    /*
     * Usage counts for tokens input using the embeddings API.
     */
    @Generated
    @JsonProperty(value = "usage")
    private EmbeddingsUsage usage;

    /**
     * Creates an instance of Embeddings class.
     *
     * @param data the data value to set.
     * @param usage the usage value to set.
     */
    @Generated
    @JsonCreator
    private Embeddings(@JsonProperty(value = "data") List<EmbeddingItem> data,
        @JsonProperty(value = "usage") EmbeddingsUsage usage) {
        this.data = data;
        this.usage = usage;
    }

    /**
     * Get the data property: Embedding values for the prompts submitted in the request.
     *
     * @return the data value.
     */
    @Generated
    public List<EmbeddingItem> getData() {
        return this.data;
    }

    /**
     * Get the usage property: Usage counts for tokens input using the embeddings API.
     *
     * @return the usage value.
     */
    @Generated
    public EmbeddingsUsage getUsage() {
        return this.usage;
    }
}
