// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Represents the request data used to generate images.
 */
@Fluent
public final class ImageGenerationOptions {

    /*
     * A description of the desired images.
     */
    @Generated
    @JsonProperty(value = "prompt")
    private String prompt;

    /*
     * The number of images to generate.
     * Dall-e-2 models support values between 1 and 10.
     * Dall-e-3 models only support a value of 1.
     */
    @Generated
    @JsonProperty(value = "n")
    private Integer n;

    /*
     * The desired dimensions for generated images.
     * Dall-e-2 models support 256x256, 512x512, or 1024x1024.
     * Dall-e-3 models support 1024x1024, 1792x1024, or 1024x1792.
     */
    @Generated
    @JsonProperty(value = "size")
    private ImageSize size;

    /*
     * A unique identifier representing your end-user, which can help to monitor and detect abuse.
     */
    @Generated
    @JsonProperty(value = "user")
    private String user;

    /**
     * Creates an instance of ImageGenerationOptions class.
     *
     * @param prompt the prompt value to set.
     */
    @Generated
    @JsonCreator
    public ImageGenerationOptions(@JsonProperty(value = "prompt") String prompt) {
        this.prompt = prompt;
    }

    /**
     * Get the prompt property: A description of the desired images.
     *
     * @return the prompt value.
     */
    @Generated
    public String getPrompt() {
        return this.prompt;
    }

    /**
     * Get the n property: The number of images to generate.
     * Dall-e-2 models support values between 1 and 10.
     * Dall-e-3 models only support a value of 1.
     *
     * @return the n value.
     */
    @Generated
    public Integer getN() {
        return this.n;
    }

    /**
     * Set the n property: The number of images to generate.
     * Dall-e-2 models support values between 1 and 10.
     * Dall-e-3 models only support a value of 1.
     *
     * @param n the n value to set.
     * @return the ImageGenerationOptions object itself.
     */
    @Generated
    public ImageGenerationOptions setN(Integer n) {
        this.n = n;
        return this;
    }

    /**
     * Get the size property: The desired dimensions for generated images.
     * Dall-e-2 models support 256x256, 512x512, or 1024x1024.
     * Dall-e-3 models support 1024x1024, 1792x1024, or 1024x1792.
     *
     * @return the size value.
     */
    @Generated
    public ImageSize getSize() {
        return this.size;
    }

    /**
     * Set the size property: The desired dimensions for generated images.
     * Dall-e-2 models support 256x256, 512x512, or 1024x1024.
     * Dall-e-3 models support 1024x1024, 1792x1024, or 1024x1792.
     *
     * @param size the size value to set.
     * @return the ImageGenerationOptions object itself.
     */
    @Generated
    public ImageGenerationOptions setSize(ImageSize size) {
        this.size = size;
        return this;
    }

    /**
     * Get the user property: A unique identifier representing your end-user, which can help to monitor and detect
     * abuse.
     *
     * @return the user value.
     */
    @Generated
    public String getUser() {
        return this.user;
    }

    /**
     * Set the user property: A unique identifier representing your end-user, which can help to monitor and detect
     * abuse.
     *
     * @param user the user value to set.
     * @return the ImageGenerationOptions object itself.
     */
    @Generated
    public ImageGenerationOptions setUser(String user) {
        this.user = user;
        return this;
    }

    /*
     * The format in which image generation response items should be presented.
     */
    @Generated
    @JsonProperty(value = "response_format")
    private ImageGenerationResponseFormat responseFormat;

    /**
     * Get the responseFormat property: The format in which image generation response items should be presented.
     *
     * @return the responseFormat value.
     */
    @Generated
    public ImageGenerationResponseFormat getResponseFormat() {
        return this.responseFormat;
    }

    /**
     * Set the responseFormat property: The format in which image generation response items should be presented.
     *
     * @param responseFormat the responseFormat value to set.
     * @return the ImageGenerationOptions object itself.
     */
    @Generated
    public ImageGenerationOptions setResponseFormat(ImageGenerationResponseFormat responseFormat) {
        this.responseFormat = responseFormat;
        return this;
    }

    /*
     * The model name or Azure OpenAI model deployment name to use for image generation. If not specified, dall-e-2
     * will be
     * inferred as a default.
     */
    @Generated
    @JsonProperty(value = "model")
    private String model;

    /*
     * The desired image generation quality level to use.
     * Only configurable with dall-e-3 models.
     */
    @Generated
    @JsonProperty(value = "quality")
    private ImageGenerationQuality quality;

    /*
     * The desired image generation style to use.
     * Only configurable with dall-e-3 models.
     */
    @Generated
    @JsonProperty(value = "style")
    private ImageGenerationStyle style;

    /**
     * Get the model property: The model name or Azure OpenAI model deployment name to use for image generation. If not
     * specified, dall-e-2 will be
     * inferred as a default.
     *
     * @return the model value.
     */
    @Generated
    public String getModel() {
        return this.model;
    }

    /**
     * Set the model property: The model name or Azure OpenAI model deployment name to use for image generation. If not
     * specified, dall-e-2 will be
     * inferred as a default.
     *
     * @param model the model value to set.
     * @return the ImageGenerationOptions object itself.
     */
    @Generated
    public ImageGenerationOptions setModel(String model) {
        this.model = model;
        return this;
    }

    /**
     * Get the quality property: The desired image generation quality level to use.
     * Only configurable with dall-e-3 models.
     *
     * @return the quality value.
     */
    @Generated
    public ImageGenerationQuality getQuality() {
        return this.quality;
    }

    /**
     * Set the quality property: The desired image generation quality level to use.
     * Only configurable with dall-e-3 models.
     *
     * @param quality the quality value to set.
     * @return the ImageGenerationOptions object itself.
     */
    @Generated
    public ImageGenerationOptions setQuality(ImageGenerationQuality quality) {
        this.quality = quality;
        return this;
    }

    /**
     * Get the style property: The desired image generation style to use.
     * Only configurable with dall-e-3 models.
     *
     * @return the style value.
     */
    @Generated
    public ImageGenerationStyle getStyle() {
        return this.style;
    }

    /**
     * Set the style property: The desired image generation style to use.
     * Only configurable with dall-e-3 models.
     *
     * @param style the style value to set.
     * @return the ImageGenerationOptions object itself.
     */
    @Generated
    public ImageGenerationOptions setStyle(ImageGenerationStyle style) {
        this.style = style;
        return this;
    }
}
