// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/**
 * An image generation configuration that specifies how the model should incorporate realism and other visual
 * characteristics.
 * Only configurable with dall-e-3 models.
 */
public final class ImageGenerationStyle extends ExpandableStringEnum<ImageGenerationStyle> {

    /**
     * Requests image generation in a natural style with less preference for dramatic and hyper-realistic
     * characteristics.
     */
    @Generated
    public static final ImageGenerationStyle NATURAL = fromString("natural");

    /**
     * Requests image generation in a vivid style with a higher preference for dramatic and hyper-realistic
     * characteristics.
     */
    @Generated
    public static final ImageGenerationStyle VIVID = fromString("vivid");

    /**
     * Creates a new instance of ImageGenerationStyle value.
     *
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Generated
    @Deprecated
    public ImageGenerationStyle() {
    }

    /**
     * Creates or finds a ImageGenerationStyle from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ImageGenerationStyle.
     */
    @Generated
    @JsonCreator
    public static ImageGenerationStyle fromString(String name) {
        return fromString(name, ImageGenerationStyle.class);
    }

    /**
     * Gets known ImageGenerationStyle values.
     *
     * @return known ImageGenerationStyle values.
     */
    @Generated
    public static Collection<ImageGenerationStyle> values() {
        return values(ImageGenerationStyle.class);
    }
}
