// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;

/**
 * The result of a successful image generation operation.
 */
@Immutable
public final class ImageGenerations {

    /*
     * A timestamp representing when this operation was started.
     * Expressed in seconds since the Unix epoch of 1970-01-01T00:00:00+0000.
     */
    @Generated
    @JsonProperty(value = "created")
    private long createdAt;

    /*
     * The images generated by the operation.
     */
    @Generated
    @JsonProperty(value = "data")
    private List<ImageGenerationData> data;

    /**
     * Creates an instance of ImageGenerations class.
     *
     * @param createdAt the createdAt value to set.
     * @param data the data value to set.
     */
    @Generated
    private ImageGenerations(OffsetDateTime createdAt, List<ImageGenerationData> data) {
        this.createdAt = createdAt.toEpochSecond();
        this.data = data;
    }

    @Generated
    @JsonCreator
    private ImageGenerations(@JsonProperty(value = "created") long createdAt,
        @JsonProperty(value = "data") List<ImageGenerationData> data) {
        this(OffsetDateTime.ofInstant(Instant.ofEpochSecond(createdAt), ZoneOffset.UTC), data);
    }

    /**
     * Get the createdAt property: A timestamp representing when this operation was started.
     * Expressed in seconds since the Unix epoch of 1970-01-01T00:00:00+0000.
     *
     * @return the createdAt value.
     */
    @Generated
    public OffsetDateTime getCreatedAt() {
        return OffsetDateTime.ofInstant(Instant.ofEpochSecond(this.createdAt), ZoneOffset.UTC);
    }

    /**
     * Get the data property: The images generated by the operation.
     *
     * @return the data value.
     */
    @Generated
    public List<ImageGenerationData> getData() {
        return this.data;
    }
}
