// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * The authentication options for Azure OpenAI On Your Data when using access token.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("access_token")
@Immutable
public final class OnYourDataAccessTokenAuthenticationOptions extends OnYourDataAuthenticationOptions {

    /*
     * The access token to use for authentication.
     */
    @Generated
    @JsonProperty(value = "access_token")
    private String accessToken;

    /**
     * Creates an instance of OnYourDataAccessTokenAuthenticationOptions class.
     *
     * @param accessToken the accessToken value to set.
     */
    @Generated
    @JsonCreator
    public OnYourDataAccessTokenAuthenticationOptions(@JsonProperty(value = "access_token") String accessToken) {
        this.accessToken = accessToken;
    }

    /**
     * Get the accessToken property: The access token to use for authentication.
     *
     * @return the accessToken value.
     */
    @Generated
    public String getAccessToken() {
        return this.accessToken;
    }
}
