// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.openai.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * A structured representation of a stop reason that signifies natural termination by the model.
 */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "type")
@JsonTypeName("stop")
@Immutable
public final class StopFinishDetails extends ChatFinishDetails {

    /*
     * The token sequence that the model terminated with.
     */
    @Generated
    @JsonProperty(value = "stop")
    private String stop;

    /**
     * Creates an instance of StopFinishDetails class.
     *
     * @param stop the stop value to set.
     */
    @Generated
    @JsonCreator
    private StopFinishDetails(@JsonProperty(value = "stop") String stop) {
        this.stop = stop;
    }

    /**
     * Get the stop property: The token sequence that the model terminated with.
     *
     * @return the stop value.
     */
    @Generated
    public String getStop() {
        return this.stop;
    }
}
