/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Duration;
import java.util.List;

public final class AudioTranslationSegment {
    @JsonProperty(value="id")
    private int id;
    @JsonProperty(value="start")
    private double start;
    @JsonProperty(value="end")
    private double end;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="temperature")
    private double temperature;
    @JsonProperty(value="avg_logprob")
    private double avgLogprob;
    @JsonProperty(value="compression_ratio")
    private double compressionRatio;
    @JsonProperty(value="no_speech_prob")
    private double noSpeechProb;
    @JsonProperty(value="tokens")
    private List<Integer> tokens;
    @JsonProperty(value="seek")
    private int seek;

    private AudioTranslationSegment(int id, Duration start, Duration end, String text, double temperature, double avgLogprob, double compressionRatio, double noSpeechProb, List<Integer> tokens, int seek) {
        this.id = id;
        this.start = (double)start.toNanos() / 1.0E9;
        this.end = (double)end.toNanos() / 1.0E9;
        this.text = text;
        this.temperature = temperature;
        this.avgLogprob = avgLogprob;
        this.compressionRatio = compressionRatio;
        this.noSpeechProb = noSpeechProb;
        this.tokens = tokens;
        this.seek = seek;
    }

    @JsonCreator
    private AudioTranslationSegment(@JsonProperty(value="id") int id, @JsonProperty(value="start") double start, @JsonProperty(value="end") double end, @JsonProperty(value="text") String text, @JsonProperty(value="temperature") double temperature, @JsonProperty(value="avg_logprob") double avgLogprob, @JsonProperty(value="compression_ratio") double compressionRatio, @JsonProperty(value="no_speech_prob") double noSpeechProb, @JsonProperty(value="tokens") List<Integer> tokens, @JsonProperty(value="seek") int seek) {
        this(id, Duration.ofNanos((long)(start * 1.0E9)), Duration.ofNanos((long)(end * 1.0E9)), text, temperature, avgLogprob, compressionRatio, noSpeechProb, tokens, seek);
    }

    public int getId() {
        return this.id;
    }

    public Duration getStart() {
        return Duration.ofNanos((long)(this.start * 1.0E9));
    }

    public Duration getEnd() {
        return Duration.ofNanos((long)(this.end * 1.0E9));
    }

    public String getText() {
        return this.text;
    }

    public double getTemperature() {
        return this.temperature;
    }

    public double getAvgLogprob() {
        return this.avgLogprob;
    }

    public double getCompressionRatio() {
        return this.compressionRatio;
    }

    public double getNoSpeechProb() {
        return this.noSpeechProb;
    }

    public List<Integer> getTokens() {
        return this.tokens;
    }

    public int getSeek() {
        return this.seek;
    }
}

