/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.policy;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import com.azure.core.util.tracing.Tracer;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class InstrumentationPolicy
implements HttpPipelinePolicy {
    private static final String HTTP_METHOD = "http.method";
    private static final String HTTP_URL = "http.url";
    private static final String HTTP_STATUS_CODE = "http.status_code";
    private static final String SERVICE_REQUEST_ID_ATTRIBUTE = "serviceRequestId";
    private static final String CLIENT_REQUEST_ID_ATTRIBUTE = "requestId";
    private static final String HTTP_RESEND_COUNT = "http.request.resend_count";
    private static final String SERVER_ADDRESS = "server.address";
    private static final String SERVER_PORT = "server.port";
    private static final ClientLogger LOGGER = new ClientLogger(InstrumentationPolicy.class);
    private Tracer tracer;

    public void initialize(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        if (!this.isTracingEnabled(context)) {
            return next.process();
        }
        return Mono.defer(() -> {
            Context span = this.startSpan(context);
            return next.process().doOnSuccess(response -> this.onResponseCode((HttpResponse)response, span)).map(response -> new TraceableResponse((HttpResponse)response, span)).doOnCancel(() -> this.tracer.end("cancelled", null, span)).doOnError(exception -> this.tracer.end(null, (Throwable)exception, span));
        });
    }

    @Override
    public HttpResponse processSync(HttpPipelineCallContext context, HttpPipelineNextSyncPolicy next) {
        TraceableResponse traceableResponse;
        block10: {
            if (!this.isTracingEnabled(context)) {
                return next.processSync();
            }
            Context span = this.startSpan(context);
            AutoCloseable scope = this.tracer.makeSpanCurrent(span);
            try {
                HttpResponse response = next.processSync();
                this.onResponseCode(response, span);
                traceableResponse = new TraceableResponse(response, span);
                if (scope == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException ex) {
                    this.tracer.end(null, (Throwable)ex, span);
                    throw ex;
                }
                catch (Exception ex) {
                    this.tracer.end(null, (Throwable)ex, span);
                    throw LOGGER.logExceptionAsWarning(new RuntimeException(ex));
                }
            }
            scope.close();
        }
        return traceableResponse;
    }

    private Context startSpan(HttpPipelineCallContext azContext) {
        HttpRequest request = azContext.getHttpRequest();
        String methodName = request.getHttpMethod().toString();
        StartSpanOptions spanOptions = new StartSpanOptions(SpanKind.CLIENT).setAttribute(HTTP_METHOD, methodName).setAttribute(HTTP_URL, request.getUrl().toString()).setAttribute(SERVER_ADDRESS, request.getUrl().getHost()).setAttribute(SERVER_PORT, InstrumentationPolicy.getPort(request.getUrl()));
        Context span = this.tracer.start(methodName, spanOptions, azContext.getContext());
        this.addPostSamplingAttributes(span, request);
        this.tracer.injectContext((k, v) -> request.getHeaders().set((String)k, (String)v), span);
        return span;
    }

    private static int getPort(URL url) {
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        return port;
    }

    private void addPostSamplingAttributes(Context span, HttpRequest request) {
        String requestId;
        Object rawRetryCount = span.getData("requestRetryCount").orElse(null);
        if (rawRetryCount instanceof Integer && (Integer)rawRetryCount > 0) {
            this.tracer.setAttribute(HTTP_RESEND_COUNT, ((Integer)rawRetryCount).longValue(), span);
        }
        if (!CoreUtils.isNullOrEmpty(requestId = request.getHeaders().getValue(HttpHeaderName.X_MS_CLIENT_REQUEST_ID))) {
            this.tracer.setAttribute(CLIENT_REQUEST_ID_ATTRIBUTE, requestId, span);
        }
    }

    private void onResponseCode(HttpResponse response, Context span) {
        if (response != null) {
            int statusCode = response.getStatusCode();
            this.tracer.setAttribute(HTTP_STATUS_CODE, statusCode, span);
            String requestId = response.getHeaderValue(HttpHeaderName.X_MS_REQUEST_ID);
            if (requestId != null) {
                this.tracer.setAttribute(SERVICE_REQUEST_ID_ATTRIBUTE, requestId, span);
            }
        }
    }

    private boolean isTracingEnabled(HttpPipelineCallContext context) {
        return this.tracer != null && this.tracer.isEnabled() && (Boolean)context.getData("disable-tracing").orElse(false) == false;
    }

    private final class TraceableResponse
    extends HttpResponse {
        private final HttpResponse response;
        private final Context span;
        private Throwable exception;
        private String errorType;

        TraceableResponse(HttpResponse response, Context span) {
            super(response.getRequest());
            this.response = response;
            this.span = span;
        }

        @Override
        public int getStatusCode() {
            return this.response.getStatusCode();
        }

        @Override
        @Deprecated
        public String getHeaderValue(String name) {
            return this.response.getHeaderValue(name);
        }

        @Override
        public String getHeaderValue(HttpHeaderName headerName) {
            return this.response.getHeaderValue(headerName);
        }

        @Override
        public HttpHeaders getHeaders() {
            return this.response.getHeaders();
        }

        @Override
        public Flux<ByteBuffer> getBody() {
            return this.response.getBody().doOnError(e -> {
                this.exception = e;
            }).doOnCancel(() -> {
                this.errorType = "cancelled";
            });
        }

        @Override
        public Mono<byte[]> getBodyAsByteArray() {
            return this.response.getBodyAsByteArray().doOnError(e -> {
                this.exception = e;
            }).doOnCancel(() -> {
                this.errorType = "cancelled";
            });
        }

        @Override
        public Mono<String> getBodyAsString() {
            return this.response.getBodyAsString().doOnError(e -> {
                this.exception = e;
            }).doOnCancel(() -> {
                this.errorType = "cancelled";
            });
        }

        @Override
        public BinaryData getBodyAsBinaryData() {
            try {
                return this.response.getBodyAsBinaryData();
            }
            catch (Exception e) {
                this.exception = e;
                throw e;
            }
        }

        @Override
        public Mono<String> getBodyAsString(Charset charset) {
            return this.response.getBodyAsString(charset).doOnError(e -> {
                this.exception = e;
            }).doOnCancel(() -> {
                this.errorType = "cancelled";
            });
        }

        @Override
        public Mono<InputStream> getBodyAsInputStream() {
            return this.response.getBodyAsInputStream().doOnError(e -> {
                this.exception = e;
            }).doOnCancel(() -> {
                this.errorType = "cancelled";
            });
        }

        @Override
        public void close() {
            this.response.close();
            int statusCode = this.response.getStatusCode();
            if (this.errorType == null && statusCode >= 400) {
                this.errorType = String.valueOf(statusCode);
            }
            InstrumentationPolicy.this.tracer.end(this.errorType, this.exception, this.span);
        }
    }
}

