// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.models;

import com.azure.core.implementation.DateTimeRfc1123;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;

/**
 * Additional parameters for a set of operations.
 */
@JacksonXmlRootElement(localName = "modified-access-conditions")
public final class ModifiedAccessConditions {
    /*
     * Specify this header value to operate only on a blob if it has been
     * modified since the specified date/time.
     */
    @JsonProperty(value = "ifModifiedSince")
    private DateTimeRfc1123 ifModifiedSince;

    /*
     * Specify this header value to operate only on a blob if it has not been
     * modified since the specified date/time.
     */
    @JsonProperty(value = "ifUnmodifiedSince")
    private DateTimeRfc1123 ifUnmodifiedSince;

    /*
     * Specify an ETag value to operate only on blobs with a matching value.
     */
    @JsonProperty(value = "ifMatch")
    private String ifMatch;

    /*
     * Specify an ETag value to operate only on blobs without a matching value.
     */
    @JsonProperty(value = "ifNoneMatch")
    private String ifNoneMatch;

    /**
     * Get the ifModifiedSince property: Specify this header value to operate
     * only on a blob if it has been modified since the specified date/time.
     *
     * @return the ifModifiedSince value.
     */
    public OffsetDateTime ifModifiedSince() {
        if (this.ifModifiedSince == null) {
            return null;
        }
        return this.ifModifiedSince.dateTime();
    }

    /**
     * Set the ifModifiedSince property: Specify this header value to operate
     * only on a blob if it has been modified since the specified date/time.
     *
     * @param ifModifiedSince the ifModifiedSince value to set.
     * @return the ModifiedAccessConditions object itself.
     */
    public ModifiedAccessConditions ifModifiedSince(OffsetDateTime ifModifiedSince) {
        if (ifModifiedSince == null) {
            this.ifModifiedSince = null;
        } else {
            this.ifModifiedSince = new DateTimeRfc1123(ifModifiedSince);
        }
        return this;
    }

    /**
     * Get the ifUnmodifiedSince property: Specify this header value to operate
     * only on a blob if it has not been modified since the specified
     * date/time.
     *
     * @return the ifUnmodifiedSince value.
     */
    public OffsetDateTime ifUnmodifiedSince() {
        if (this.ifUnmodifiedSince == null) {
            return null;
        }
        return this.ifUnmodifiedSince.dateTime();
    }

    /**
     * Set the ifUnmodifiedSince property: Specify this header value to operate
     * only on a blob if it has not been modified since the specified
     * date/time.
     *
     * @param ifUnmodifiedSince the ifUnmodifiedSince value to set.
     * @return the ModifiedAccessConditions object itself.
     */
    public ModifiedAccessConditions ifUnmodifiedSince(OffsetDateTime ifUnmodifiedSince) {
        if (ifUnmodifiedSince == null) {
            this.ifUnmodifiedSince = null;
        } else {
            this.ifUnmodifiedSince = new DateTimeRfc1123(ifUnmodifiedSince);
        }
        return this;
    }

    /**
     * Get the ifMatch property: Specify an ETag value to operate only on blobs
     * with a matching value.
     *
     * @return the ifMatch value.
     */
    public String ifMatch() {
        return this.ifMatch;
    }

    /**
     * Set the ifMatch property: Specify an ETag value to operate only on blobs
     * with a matching value.
     *
     * @param ifMatch the ifMatch value to set.
     * @return the ModifiedAccessConditions object itself.
     */
    public ModifiedAccessConditions ifMatch(String ifMatch) {
        this.ifMatch = ifMatch;
        return this;
    }

    /**
     * Get the ifNoneMatch property: Specify an ETag value to operate only on
     * blobs without a matching value.
     *
     * @return the ifNoneMatch value.
     */
    public String ifNoneMatch() {
        return this.ifNoneMatch;
    }

    /**
     * Set the ifNoneMatch property: Specify an ETag value to operate only on
     * blobs without a matching value.
     *
     * @param ifNoneMatch the ifNoneMatch value to set.
     * @return the ModifiedAccessConditions object itself.
     */
    public ModifiedAccessConditions ifNoneMatch(String ifNoneMatch) {
        this.ifNoneMatch = ifNoneMatch;
        return this;
    }
}
