// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.storage.blob.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;

/**
 * delimited text configuration.
 */
@JacksonXmlRootElement(localName = "DelimitedTextConfiguration")
@Fluent
public final class DelimitedTextConfiguration {
    /*
     * column separator
     */
    @JsonProperty(value = "ColumnSeparator", required = true)
    private String columnSeparator;

    /*
     * field quote
     */
    @JsonProperty(value = "FieldQuote", required = true)
    private String fieldQuote;

    /*
     * record separator
     */
    @JsonProperty(value = "RecordSeparator", required = true)
    private String recordSeparator;

    /*
     * escape char
     */
    @JsonProperty(value = "EscapeChar", required = true)
    private String escapeChar;

    /*
     * has headers
     */
    @JsonProperty(value = "HasHeaders", required = true)
    private boolean headersPresent;

    /**
     * Get the columnSeparator property: column separator.
     *
     * @return the columnSeparator value.
     */
    public String getColumnSeparator() {
        return this.columnSeparator;
    }

    /**
     * Set the columnSeparator property: column separator.
     *
     * @param columnSeparator the columnSeparator value to set.
     * @return the DelimitedTextConfiguration object itself.
     */
    public DelimitedTextConfiguration setColumnSeparator(String columnSeparator) {
        this.columnSeparator = columnSeparator;
        return this;
    }

    /**
     * Get the fieldQuote property: field quote.
     *
     * @return the fieldQuote value.
     */
    public String getFieldQuote() {
        return this.fieldQuote;
    }

    /**
     * Set the fieldQuote property: field quote.
     *
     * @param fieldQuote the fieldQuote value to set.
     * @return the DelimitedTextConfiguration object itself.
     */
    public DelimitedTextConfiguration setFieldQuote(String fieldQuote) {
        this.fieldQuote = fieldQuote;
        return this;
    }

    /**
     * Get the recordSeparator property: record separator.
     *
     * @return the recordSeparator value.
     */
    public String getRecordSeparator() {
        return this.recordSeparator;
    }

    /**
     * Set the recordSeparator property: record separator.
     *
     * @param recordSeparator the recordSeparator value to set.
     * @return the DelimitedTextConfiguration object itself.
     */
    public DelimitedTextConfiguration setRecordSeparator(String recordSeparator) {
        this.recordSeparator = recordSeparator;
        return this;
    }

    /**
     * Get the escapeChar property: escape char.
     *
     * @return the escapeChar value.
     */
    public String getEscapeChar() {
        return this.escapeChar;
    }

    /**
     * Set the escapeChar property: escape char.
     *
     * @param escapeChar the escapeChar value to set.
     * @return the DelimitedTextConfiguration object itself.
     */
    public DelimitedTextConfiguration setEscapeChar(String escapeChar) {
        this.escapeChar = escapeChar;
        return this;
    }

    /**
     * Get the headersPresent property: has headers.
     *
     * @return the headersPresent value.
     */
    public boolean isHeadersPresent() {
        return this.headersPresent;
    }

    /**
     * Set the headersPresent property: has headers.
     *
     * @param headersPresent the headersPresent value to set.
     * @return the DelimitedTextConfiguration object itself.
     */
    public DelimitedTextConfiguration setHeadersPresent(boolean headersPresent) {
        this.headersPresent = headersPresent;
        return this;
    }
}
