// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Managed identity properties retrieved from ARM request headers. */
@Fluent
public final class ManagedIdentityProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ManagedIdentityProperties.class);

    /*
     * Type of the managed identity
     */
    @JsonProperty(value = "type")
    private ManagedIdentityType type;

    /*
     * Principal Id
     */
    @JsonProperty(value = "principalId")
    private String principalId;

    /*
     * Tenant Id
     */
    @JsonProperty(value = "tenantId")
    private String tenantId;

    /**
     * Get the type property: Type of the managed identity.
     *
     * @return the type value.
     */
    public ManagedIdentityType type() {
        return this.type;
    }

    /**
     * Set the type property: Type of the managed identity.
     *
     * @param type the type value to set.
     * @return the ManagedIdentityProperties object itself.
     */
    public ManagedIdentityProperties withType(ManagedIdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the principalId property: Principal Id.
     *
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Set the principalId property: Principal Id.
     *
     * @param principalId the principalId value to set.
     * @return the ManagedIdentityProperties object itself.
     */
    public ManagedIdentityProperties withPrincipalId(String principalId) {
        this.principalId = principalId;
        return this;
    }

    /**
     * Get the tenantId property: Tenant Id.
     *
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Set the tenantId property: Tenant Id.
     *
     * @param tenantId the tenantId value to set.
     * @return the ManagedIdentityProperties object itself.
     */
    public ManagedIdentityProperties withTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
