// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appplatform.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Monitoring Setting properties payload. */
@Fluent
public final class MonitoringSettingProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(MonitoringSettingProperties.class);

    /*
     * State of the Monitoring Setting.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private MonitoringSettingState provisioningState;

    /*
     * Error when apply Monitoring Setting changes.
     */
    @JsonProperty(value = "error")
    private Error error;

    /*
     * Indicates whether enable the trace functionality
     */
    @JsonProperty(value = "traceEnabled")
    private Boolean traceEnabled;

    /*
     * Target application insight instrumentation key
     */
    @JsonProperty(value = "appInsightsInstrumentationKey")
    private String appInsightsInstrumentationKey;

    /**
     * Get the provisioningState property: State of the Monitoring Setting.
     *
     * @return the provisioningState value.
     */
    public MonitoringSettingState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the error property: Error when apply Monitoring Setting changes.
     *
     * @return the error value.
     */
    public Error error() {
        return this.error;
    }

    /**
     * Set the error property: Error when apply Monitoring Setting changes.
     *
     * @param error the error value to set.
     * @return the MonitoringSettingProperties object itself.
     */
    public MonitoringSettingProperties withError(Error error) {
        this.error = error;
        return this;
    }

    /**
     * Get the traceEnabled property: Indicates whether enable the trace functionality.
     *
     * @return the traceEnabled value.
     */
    public Boolean traceEnabled() {
        return this.traceEnabled;
    }

    /**
     * Set the traceEnabled property: Indicates whether enable the trace functionality.
     *
     * @param traceEnabled the traceEnabled value to set.
     * @return the MonitoringSettingProperties object itself.
     */
    public MonitoringSettingProperties withTraceEnabled(Boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        return this;
    }

    /**
     * Get the appInsightsInstrumentationKey property: Target application insight instrumentation key.
     *
     * @return the appInsightsInstrumentationKey value.
     */
    public String appInsightsInstrumentationKey() {
        return this.appInsightsInstrumentationKey;
    }

    /**
     * Set the appInsightsInstrumentationKey property: Target application insight instrumentation key.
     *
     * @param appInsightsInstrumentationKey the appInsightsInstrumentationKey value to set.
     * @return the MonitoringSettingProperties object itself.
     */
    public MonitoringSettingProperties withAppInsightsInstrumentationKey(String appInsightsInstrumentationKey) {
        this.appInsightsInstrumentationKey = appInsightsInstrumentationKey;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (error() != null) {
            error().validate();
        }
    }
}
