/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appplatform.fluent.ConfigServersClient;
import com.azure.resourcemanager.appplatform.fluent.models.ConfigServerResourceInner;
import com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.azure.resourcemanager.appplatform.models.ConfigServerProperties;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ConfigServersClientImpl
implements ConfigServersClient {
    private final ClientLogger logger = new ClientLogger(ConfigServersClientImpl.class);
    private final ConfigServersService service;
    private final AppPlatformManagementClientImpl client;

    ConfigServersClientImpl(AppPlatformManagementClientImpl client) {
        this.service = (ConfigServersService)RestProxy.create(ConfigServersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<ConfigServerResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<ConfigServerResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, context);
    }

    @Override
    public Mono<ConfigServerResourceInner> getAsync(String resourceGroupName, String serviceName) {
        return this.getWithResponseAsync(resourceGroupName, serviceName).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Object)((ConfigServerResourceInner)((Object)((Object)res.getValue())))));
            }
            return Mono.empty();
        });
    }

    @Override
    public ConfigServerResourceInner get(String resourceGroupName, String serviceName) {
        return (ConfigServerResourceInner)((Object)this.getAsync(resourceGroupName, serviceName).block());
    }

    @Override
    public Response<ConfigServerResourceInner> getWithResponse(String resourceGroupName, String serviceName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, serviceName, context).block();
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updatePutWithResponseAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        ConfigServerResourceInner configServerResource = new ConfigServerResourceInner();
        configServerResource.withProperties(properties);
        return FluxUtil.withContext(context -> this.service.updatePut(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configServerResource, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updatePutWithResponseAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        ConfigServerResourceInner configServerResource = new ConfigServerResourceInner();
        configServerResource.withProperties(properties);
        context = this.client.mergeContext(context);
        return this.service.updatePut(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configServerResource, context);
    }

    @Override
    public PollerFlux<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePutAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updatePutWithResponseAsync(resourceGroupName, serviceName, properties);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConfigServerResourceInner.class), (Type)((Object)ConfigServerResourceInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePutAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updatePutWithResponseAsync(resourceGroupName, serviceName, properties, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConfigServerResourceInner.class), (Type)((Object)ConfigServerResourceInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePut(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, properties).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePut(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, properties, context).getSyncPoller();
    }

    @Override
    public Mono<ConfigServerResourceInner> updatePutAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, properties).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ConfigServerResourceInner> updatePutAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, properties, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<ConfigServerResourceInner> updatePutAsync(String resourceGroupName, String serviceName) {
        ConfigServerProperties properties = null;
        return this.beginUpdatePutAsync(resourceGroupName, serviceName, properties).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ConfigServerResourceInner updatePut(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        return (ConfigServerResourceInner)((Object)this.updatePutAsync(resourceGroupName, serviceName, properties).block());
    }

    @Override
    public ConfigServerResourceInner updatePut(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        return (ConfigServerResourceInner)((Object)this.updatePutAsync(resourceGroupName, serviceName, properties, context).block());
    }

    @Override
    public ConfigServerResourceInner updatePut(String resourceGroupName, String serviceName) {
        ConfigServerProperties properties = null;
        return (ConfigServerResourceInner)((Object)this.updatePutAsync(resourceGroupName, serviceName, properties).block());
    }

    @Override
    public Mono<Response<Flux<ByteBuffer>>> updatePatchWithResponseAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        ConfigServerResourceInner configServerResource = new ConfigServerResourceInner();
        configServerResource.withProperties(properties);
        return FluxUtil.withContext(context -> this.service.updatePatch(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configServerResource, (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Flux<ByteBuffer>>> updatePatchWithResponseAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (properties != null) {
            properties.validate();
        }
        ConfigServerResourceInner configServerResource = new ConfigServerResourceInner();
        configServerResource.withProperties(properties);
        context = this.client.mergeContext(context);
        return this.service.updatePatch(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configServerResource, context);
    }

    @Override
    public PollerFlux<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePatchAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updatePatchWithResponseAsync(resourceGroupName, serviceName, properties);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConfigServerResourceInner.class), (Type)((Object)ConfigServerResourceInner.class), Context.NONE);
    }

    private PollerFlux<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePatchAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updatePatchWithResponseAsync(resourceGroupName, serviceName, properties, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)ConfigServerResourceInner.class), (Type)((Object)ConfigServerResourceInner.class), context);
    }

    @Override
    public SyncPoller<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePatch(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        return this.beginUpdatePatchAsync(resourceGroupName, serviceName, properties).getSyncPoller();
    }

    @Override
    public SyncPoller<PollResult<ConfigServerResourceInner>, ConfigServerResourceInner> beginUpdatePatch(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        return this.beginUpdatePatchAsync(resourceGroupName, serviceName, properties, context).getSyncPoller();
    }

    @Override
    public Mono<ConfigServerResourceInner> updatePatchAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        return this.beginUpdatePatchAsync(resourceGroupName, serviceName, properties).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    private Mono<ConfigServerResourceInner> updatePatchAsync(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        return this.beginUpdatePatchAsync(resourceGroupName, serviceName, properties, context).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public Mono<ConfigServerResourceInner> updatePatchAsync(String resourceGroupName, String serviceName) {
        ConfigServerProperties properties = null;
        return this.beginUpdatePatchAsync(resourceGroupName, serviceName, properties).last().flatMap(arg_0 -> ((AppPlatformManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    public ConfigServerResourceInner updatePatch(String resourceGroupName, String serviceName, ConfigServerProperties properties) {
        return (ConfigServerResourceInner)((Object)this.updatePatchAsync(resourceGroupName, serviceName, properties).block());
    }

    @Override
    public ConfigServerResourceInner updatePatch(String resourceGroupName, String serviceName, ConfigServerProperties properties, Context context) {
        return (ConfigServerResourceInner)((Object)this.updatePatchAsync(resourceGroupName, serviceName, properties, context).block());
    }

    @Override
    public ConfigServerResourceInner updatePatch(String resourceGroupName, String serviceName) {
        ConfigServerProperties properties = null;
        return (ConfigServerResourceInner)((Object)this.updatePatchAsync(resourceGroupName, serviceName, properties).block());
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    private static interface ConfigServersService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configServers/default")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigServerResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configServers/default")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updatePut(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @BodyParam(value="application/json") ConfigServerResourceInner var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configServers/default")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> updatePatch(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @BodyParam(value="application/json") ConfigServerResourceInner var6, Context var7);
    }
}

