/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.appplatform.fluent.RuntimeVersionsClient;
import com.azure.resourcemanager.appplatform.fluent.models.AvailableRuntimeVersionsInner;
import com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import reactor.core.publisher.Mono;

public final class RuntimeVersionsClientImpl
implements RuntimeVersionsClient {
    private final ClientLogger logger = new ClientLogger(RuntimeVersionsClientImpl.class);
    private final RuntimeVersionsService service;
    private final AppPlatformManagementClientImpl client;

    RuntimeVersionsClientImpl(AppPlatformManagementClientImpl client) {
        this.service = (RuntimeVersionsService)RestProxy.create(RuntimeVersionsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<AvailableRuntimeVersionsInner>> listRuntimeVersionsWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRuntimeVersions(this.client.getEndpoint(), this.client.getApiVersion(), (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<AvailableRuntimeVersionsInner>> listRuntimeVersionsWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRuntimeVersions(this.client.getEndpoint(), this.client.getApiVersion(), context);
    }

    @Override
    public Mono<AvailableRuntimeVersionsInner> listRuntimeVersionsAsync() {
        return this.listRuntimeVersionsWithResponseAsync().flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((AvailableRuntimeVersionsInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public AvailableRuntimeVersionsInner listRuntimeVersions() {
        return (AvailableRuntimeVersionsInner)this.listRuntimeVersionsAsync().block();
    }

    @Override
    public Response<AvailableRuntimeVersionsInner> listRuntimeVersionsWithResponse(Context context) {
        return (Response)this.listRuntimeVersionsWithResponseAsync(context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    private static interface RuntimeVersionsService {
        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="/providers/Microsoft.AppPlatform/runtimeVersions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<AvailableRuntimeVersionsInner>> listRuntimeVersions(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, Context var3);
    }
}

