/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.fluent.AppsClient;
import com.azure.resourcemanager.appplatform.fluent.models.AppResourceInner;
import com.azure.resourcemanager.appplatform.implementation.SpringAppImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringServiceImpl;
import com.azure.resourcemanager.appplatform.models.SpringApp;
import com.azure.resourcemanager.appplatform.models.SpringApps;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesNonCachedImpl;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ExternalChildResourceImpl;
import reactor.core.publisher.Mono;

public class SpringAppsImpl
extends ExternalChildResourcesNonCachedImpl<SpringAppImpl, SpringApp, AppResourceInner, SpringServiceImpl, SpringService>
implements SpringApps {
    SpringAppsImpl(SpringServiceImpl parent) {
        super((Object)parent, parent.taskGroup(), "SpringApp");
    }

    public SpringApp getById(String id) {
        return (SpringApp)this.getByIdAsync(id).block();
    }

    public Mono<SpringApp> getByIdAsync(String id) {
        return this.getByNameAsync(ResourceUtils.nameFromResourceId((String)id));
    }

    public SpringApp getByName(String name) {
        return (SpringApp)this.getByNameAsync(name).block();
    }

    public Mono<SpringApp> getByNameAsync(String name) {
        return this.inner().getAsync(this.parent().resourceGroupName(), this.parent().name(), name).map(this::wrapModel);
    }

    public AppPlatformManager manager() {
        return (AppPlatformManager)this.parent().manager();
    }

    public SpringServiceImpl parent() {
        return (SpringServiceImpl)super.getParent();
    }

    public SpringAppImpl define(String name) {
        return (SpringAppImpl)super.prepareIndependentDefine((ExternalChildResourceImpl)this.wrapModel(name));
    }

    public void deleteById(String id) {
        this.deleteByIdAsync(id).block();
    }

    public Mono<Void> deleteByIdAsync(String id) {
        return this.deleteByNameAsync(ResourceUtils.nameFromResourceId((String)id));
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).block();
    }

    public Mono<Void> deleteByNameAsync(String name) {
        return this.inner().deleteAsync(this.parent().resourceGroupName(), this.parent().name(), name);
    }

    public PagedIterable<SpringApp> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<SpringApp> listAsync() {
        return this.inner().listAsync(this.parent().resourceGroupName(), this.parent().name()).mapPage(this::wrapModel);
    }

    private SpringAppImpl wrapModel(AppResourceInner inner) {
        return inner == null ? null : new SpringAppImpl(inner.name(), this.parent(), inner);
    }

    private SpringAppImpl wrapModel(String name) {
        return new SpringAppImpl(name, this.parent(), new AppResourceInner());
    }

    public AppsClient inner() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getApps();
    }
}

