/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appplatform.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.appplatform.AppPlatformManager;
import com.azure.resourcemanager.appplatform.fluent.AppPlatformManagementClient;
import com.azure.resourcemanager.appplatform.fluent.CertificatesClient;
import com.azure.resourcemanager.appplatform.fluent.models.CertificateResourceInner;
import com.azure.resourcemanager.appplatform.implementation.SpringServiceCertificateImpl;
import com.azure.resourcemanager.appplatform.implementation.SpringServiceImpl;
import com.azure.resourcemanager.appplatform.models.CertificateProperties;
import com.azure.resourcemanager.appplatform.models.SpringService;
import com.azure.resourcemanager.appplatform.models.SpringServiceCertificate;
import com.azure.resourcemanager.appplatform.models.SpringServiceCertificates;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesNonCachedImpl;
import reactor.core.publisher.Mono;

public class SpringServiceCertificatesImpl
extends ExternalChildResourcesNonCachedImpl<SpringServiceCertificateImpl, SpringServiceCertificate, CertificateResourceInner, SpringServiceImpl, SpringService>
implements SpringServiceCertificates {
    SpringServiceCertificatesImpl(SpringServiceImpl parent) {
        super((Object)parent, parent.taskGroup(), "SpringServiceCertificate");
    }

    public SpringServiceCertificate getById(String id) {
        return (SpringServiceCertificate)this.getByIdAsync(id).block();
    }

    public Mono<SpringServiceCertificate> getByIdAsync(String id) {
        return this.getByNameAsync(ResourceUtils.nameFromResourceId((String)id));
    }

    public SpringServiceCertificate getByName(String name) {
        return (SpringServiceCertificate)this.getByNameAsync(name).block();
    }

    public Mono<SpringServiceCertificate> getByNameAsync(String name) {
        return this.inner().getAsync(this.parent().resourceGroupName(), this.parent().name(), name).map(this::wrapModel);
    }

    SpringServiceCertificateImpl wrapModel(CertificateResourceInner inner) {
        return inner == null ? null : new SpringServiceCertificateImpl(inner.name(), this.parent(), inner);
    }

    public AppPlatformManager manager() {
        return (AppPlatformManager)this.parent().manager();
    }

    public SpringServiceImpl parent() {
        return (SpringServiceImpl)this.getParent();
    }

    public void deleteById(String id) {
        this.deleteByIdAsync(id).block();
    }

    public Mono<Void> deleteByIdAsync(String id) {
        return this.deleteByNameAsync(ResourceUtils.nameFromResourceId((String)id));
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).block();
    }

    public Mono<Void> deleteByNameAsync(String name) {
        return this.inner().deleteAsync(this.parent().resourceGroupName(), this.parent().name(), name);
    }

    public PagedIterable<SpringServiceCertificate> list() {
        return new PagedIterable(this.listAsync());
    }

    public PagedFlux<SpringServiceCertificate> listAsync() {
        return this.inner().listAsync(this.parent().resourceGroupName(), this.parent().name()).mapPage(this::wrapModel);
    }

    public CertificatesClient inner() {
        return ((AppPlatformManagementClient)this.manager().serviceClient()).getCertificates();
    }

    SpringServiceCertificate prepareCreateOrUpdate(String name, CertificateProperties properties) {
        return (SpringServiceCertificate)this.prepareInlineDefine(new SpringServiceCertificateImpl(name, this.parent(), new CertificateResourceInner().withProperties(properties)));
    }

    void prepareDelete(String name) {
        this.prepareInlineRemove(new SpringServiceCertificateImpl(name, this.parent(), new CertificateResourceInner()));
    }
}

